package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ResourcePolicyDocument,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetImageRecipePolicyResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    policy: Optional[ResourcePolicyDocument] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetImageRecipePolicyResponse = {
    import GetImageRecipePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetImageRecipePolicyResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        policy.map(value =>
          ResourcePolicyDocument.unwrap(value): java.lang.String
        )
      )(_.policy)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.GetImageRecipePolicyResponse.ReadOnly =
    zio.aws.imagebuilder.model.GetImageRecipePolicyResponse
      .wrap(buildAwsValue())
}
object GetImageRecipePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetImageRecipePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.GetImageRecipePolicyResponse =
      zio.aws.imagebuilder.model.GetImageRecipePolicyResponse(
        requestId.map(value => value),
        policy.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def policy: Optional[ResourcePolicyDocument]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getPolicy: ZIO[Any, AwsError, ResourcePolicyDocument] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetImageRecipePolicyResponse
  ) extends zio.aws.imagebuilder.model.GetImageRecipePolicyResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val policy: Optional[ResourcePolicyDocument] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policy())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ResourcePolicyDocument(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetImageRecipePolicyResponse
  ): zio.aws.imagebuilder.model.GetImageRecipePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
