package zio.aws.imagebuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Logging(
    s3Logs: Optional[zio.aws.imagebuilder.model.S3Logs] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.Logging = {
    import Logging.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.Logging
      .builder()
      .optionallyWith(s3Logs.map(value => value.buildAwsValue()))(_.s3Logs)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.Logging.ReadOnly =
    zio.aws.imagebuilder.model.Logging.wrap(buildAwsValue())
}
object Logging {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.Logging
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.Logging =
      zio.aws.imagebuilder.model.Logging(s3Logs.map(value => value.asEditable))
    def s3Logs: Optional[zio.aws.imagebuilder.model.S3Logs.ReadOnly]
    def getS3Logs
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.S3Logs.ReadOnly] =
      AwsError.unwrapOptionField("s3Logs", s3Logs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.Logging
  ) extends zio.aws.imagebuilder.model.Logging.ReadOnly {
    override val s3Logs: Optional[zio.aws.imagebuilder.model.S3Logs.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Logs())
        .map(value => zio.aws.imagebuilder.model.S3Logs.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.Logging
  ): zio.aws.imagebuilder.model.Logging.ReadOnly = new Wrapper(impl)
}
