package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetComponentResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    component: Optional[zio.aws.imagebuilder.model.Component] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetComponentResponse = {
    import GetComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetComponentResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(component.map(value => value.buildAwsValue()))(
        _.component
      )
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.GetComponentResponse.ReadOnly =
    zio.aws.imagebuilder.model.GetComponentResponse.wrap(buildAwsValue())
}
object GetComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.GetComponentResponse =
      zio.aws.imagebuilder.model.GetComponentResponse(
        requestId.map(value => value),
        component.map(value => value.asEditable)
      )
    def requestId: Optional[NonEmptyString]
    def component: Optional[zio.aws.imagebuilder.model.Component.ReadOnly]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getComponent
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.Component.ReadOnly] =
      AwsError.unwrapOptionField("component", component)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetComponentResponse
  ) extends zio.aws.imagebuilder.model.GetComponentResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val component
        : Optional[zio.aws.imagebuilder.model.Component.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.component())
        .map(value => zio.aws.imagebuilder.model.Component.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetComponentResponse
  ): zio.aws.imagebuilder.model.GetComponentResponse.ReadOnly = new Wrapper(
    impl
  )
}
