package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  OrganizationalUnitArn,
  OrganizationArn,
  NonEmptyString,
  AccountId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchPermissionConfiguration(
    userIds: Option[Iterable[AccountId]] = None,
    userGroups: Option[Iterable[NonEmptyString]] = None,
    organizationArns: Option[Iterable[OrganizationArn]] = None,
    organizationalUnitArns: Option[Iterable[OrganizationalUnitArn]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.LaunchPermissionConfiguration = {
    import LaunchPermissionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.LaunchPermissionConfiguration
      .builder()
      .optionallyWith(
        userIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userIds)
      .optionallyWith(
        userGroups.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userGroups)
      .optionallyWith(
        organizationArns.map(value =>
          value.map { item =>
            OrganizationArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.organizationArns)
      .optionallyWith(
        organizationalUnitArns.map(value =>
          value.map { item =>
            OrganizationalUnitArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.organizationalUnitArns)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.LaunchPermissionConfiguration.ReadOnly =
    zio.aws.imagebuilder.model.LaunchPermissionConfiguration
      .wrap(buildAwsValue())
}
object LaunchPermissionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.LaunchPermissionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.LaunchPermissionConfiguration =
      zio.aws.imagebuilder.model.LaunchPermissionConfiguration(
        userIds.map(value => value),
        userGroups.map(value => value),
        organizationArns.map(value => value),
        organizationalUnitArns.map(value => value)
      )
    def userIds: Option[List[AccountId]]
    def userGroups: Option[List[NonEmptyString]]
    def organizationArns: Option[List[OrganizationArn]]
    def organizationalUnitArns: Option[List[OrganizationalUnitArn]]
    def getUserIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("userIds", userIds)
    def getUserGroups: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("userGroups", userGroups)
    def getOrganizationArns: ZIO[Any, AwsError, List[OrganizationArn]] =
      AwsError.unwrapOptionField("organizationArns", organizationArns)
    def getOrganizationalUnitArns
        : ZIO[Any, AwsError, List[OrganizationalUnitArn]] = AwsError
      .unwrapOptionField("organizationalUnitArns", organizationalUnitArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.LaunchPermissionConfiguration
  ) extends zio.aws.imagebuilder.model.LaunchPermissionConfiguration.ReadOnly {
    override val userIds: Option[List[AccountId]] = scala
      .Option(impl.userIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.primitives.AccountId(item)
        }.toList
      )
    override val userGroups: Option[List[NonEmptyString]] = scala
      .Option(impl.userGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val organizationArns: Option[List[OrganizationArn]] = scala
      .Option(impl.organizationArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.primitives.OrganizationArn(item)
        }.toList
      )
    override val organizationalUnitArns: Option[List[OrganizationalUnitArn]] =
      scala
        .Option(impl.organizationalUnitArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.primitives.OrganizationalUnitArn(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.LaunchPermissionConfiguration
  ): zio.aws.imagebuilder.model.LaunchPermissionConfiguration.ReadOnly =
    new Wrapper(impl)
}
