package zio.aws.imagebuilder.model
import java.lang.Integer
import zio.aws.imagebuilder.model.primitives.{AccountId, MaxParallelLaunches}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FastLaunchConfiguration(
    enabled: Boolean,
    snapshotConfiguration: Option[
      zio.aws.imagebuilder.model.FastLaunchSnapshotConfiguration
    ] = None,
    maxParallelLaunches: Option[MaxParallelLaunches] = None,
    launchTemplate: Option[
      zio.aws.imagebuilder.model.FastLaunchLaunchTemplateSpecification
    ] = None,
    accountId: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.FastLaunchConfiguration = {
    import FastLaunchConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.FastLaunchConfiguration
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(
        snapshotConfiguration.map(value => value.buildAwsValue())
      )(_.snapshotConfiguration)
      .optionallyWith(
        maxParallelLaunches.map(value =>
          MaxParallelLaunches.unwrap(value): Integer
        )
      )(_.maxParallelLaunches)
      .optionallyWith(launchTemplate.map(value => value.buildAwsValue()))(
        _.launchTemplate
      )
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.FastLaunchConfiguration.ReadOnly =
    zio.aws.imagebuilder.model.FastLaunchConfiguration.wrap(buildAwsValue())
}
object FastLaunchConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.FastLaunchConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.FastLaunchConfiguration =
      zio.aws.imagebuilder.model.FastLaunchConfiguration(
        enabled,
        snapshotConfiguration.map(value => value.asEditable),
        maxParallelLaunches.map(value => value),
        launchTemplate.map(value => value.asEditable),
        accountId.map(value => value)
      )
    def enabled: Boolean
    def snapshotConfiguration: Option[
      zio.aws.imagebuilder.model.FastLaunchSnapshotConfiguration.ReadOnly
    ]
    def maxParallelLaunches: Option[MaxParallelLaunches]
    def launchTemplate: Option[
      zio.aws.imagebuilder.model.FastLaunchLaunchTemplateSpecification.ReadOnly
    ]
    def accountId: Option[AccountId]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getSnapshotConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.FastLaunchSnapshotConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("snapshotConfiguration", snapshotConfiguration)
    def getMaxParallelLaunches: ZIO[Any, AwsError, MaxParallelLaunches] =
      AwsError.unwrapOptionField("maxParallelLaunches", maxParallelLaunches)
    def getLaunchTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.FastLaunchLaunchTemplateSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("launchTemplate", launchTemplate)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.FastLaunchConfiguration
  ) extends zio.aws.imagebuilder.model.FastLaunchConfiguration.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val snapshotConfiguration: Option[
      zio.aws.imagebuilder.model.FastLaunchSnapshotConfiguration.ReadOnly
    ] = scala
      .Option(impl.snapshotConfiguration())
      .map(value =>
        zio.aws.imagebuilder.model.FastLaunchSnapshotConfiguration.wrap(value)
      )
    override val maxParallelLaunches: Option[MaxParallelLaunches] = scala
      .Option(impl.maxParallelLaunches())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.MaxParallelLaunches(value)
      )
    override val launchTemplate: Option[
      zio.aws.imagebuilder.model.FastLaunchLaunchTemplateSpecification.ReadOnly
    ] = scala
      .Option(impl.launchTemplate())
      .map(value =>
        zio.aws.imagebuilder.model.FastLaunchLaunchTemplateSpecification
          .wrap(value)
      )
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.imagebuilder.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.FastLaunchConfiguration
  ): zio.aws.imagebuilder.model.FastLaunchConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
