package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  InstanceProfileNameType,
  InfrastructureConfigurationArn,
  TagValue,
  SnsTopicArn,
  InstanceType,
  ClientToken,
  NullableBoolean,
  NonEmptyString,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateInfrastructureConfigurationRequest(
    infrastructureConfigurationArn: InfrastructureConfigurationArn,
    description: Option[NonEmptyString] = None,
    instanceTypes: Option[Iterable[InstanceType]] = None,
    instanceProfileName: InstanceProfileNameType,
    securityGroupIds: Option[Iterable[NonEmptyString]] = None,
    subnetId: Option[NonEmptyString] = None,
    logging: Option[zio.aws.imagebuilder.model.Logging] = None,
    keyPair: Option[NonEmptyString] = None,
    terminateInstanceOnFailure: Option[NullableBoolean] = None,
    snsTopicArn: Option[SnsTopicArn] = None,
    clientToken: ClientToken,
    resourceTags: Option[Map[TagKey, TagValue]] = None,
    instanceMetadataOptions: Option[
      zio.aws.imagebuilder.model.InstanceMetadataOptions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationRequest = {
    import UpdateInfrastructureConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationRequest
      .builder()
      .infrastructureConfigurationArn(
        InfrastructureConfigurationArn.unwrap(
          infrastructureConfigurationArn
        ): java.lang.String
      )
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        instanceTypes.map(value =>
          value.map { item =>
            InstanceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceTypes)
      .instanceProfileName(
        InstanceProfileNameType.unwrap(instanceProfileName): java.lang.String
      )
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        subnetId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(logging.map(value => value.buildAwsValue()))(_.logging)
      .optionallyWith(
        keyPair.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyPair)
      .optionallyWith(
        terminateInstanceOnFailure.map(value => value: java.lang.Boolean)
      )(_.terminateInstanceOnFailure)
      .optionallyWith(
        snsTopicArn.map(value => SnsTopicArn.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .optionallyWith(
        resourceTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.resourceTags)
      .optionallyWith(
        instanceMetadataOptions.map(value => value.buildAwsValue())
      )(_.instanceMetadataOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationRequest.ReadOnly =
    zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateInfrastructureConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationRequest =
      zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationRequest(
        infrastructureConfigurationArn,
        description.map(value => value),
        instanceTypes.map(value => value),
        instanceProfileName,
        securityGroupIds.map(value => value),
        subnetId.map(value => value),
        logging.map(value => value.asEditable),
        keyPair.map(value => value),
        terminateInstanceOnFailure.map(value => value),
        snsTopicArn.map(value => value),
        clientToken,
        resourceTags.map(value => value),
        instanceMetadataOptions.map(value => value.asEditable)
      )
    def infrastructureConfigurationArn: InfrastructureConfigurationArn
    def description: Option[NonEmptyString]
    def instanceTypes: Option[List[InstanceType]]
    def instanceProfileName: InstanceProfileNameType
    def securityGroupIds: Option[List[NonEmptyString]]
    def subnetId: Option[NonEmptyString]
    def logging: Option[zio.aws.imagebuilder.model.Logging.ReadOnly]
    def keyPair: Option[NonEmptyString]
    def terminateInstanceOnFailure: Option[NullableBoolean]
    def snsTopicArn: Option[SnsTopicArn]
    def clientToken: ClientToken
    def resourceTags: Option[Map[TagKey, TagValue]]
    def instanceMetadataOptions
        : Option[zio.aws.imagebuilder.model.InstanceMetadataOptions.ReadOnly]
    def getInfrastructureConfigurationArn
        : ZIO[Any, Nothing, InfrastructureConfigurationArn] =
      ZIO.succeed(infrastructureConfigurationArn)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getInstanceTypes: ZIO[Any, AwsError, List[InstanceType]] =
      AwsError.unwrapOptionField("instanceTypes", instanceTypes)
    def getInstanceProfileName: ZIO[Any, Nothing, InstanceProfileNameType] =
      ZIO.succeed(instanceProfileName)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getLogging
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.Logging.ReadOnly] =
      AwsError.unwrapOptionField("logging", logging)
    def getKeyPair: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyPair", keyPair)
    def getTerminateInstanceOnFailure: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField(
        "terminateInstanceOnFailure",
        terminateInstanceOnFailure
      )
    def getSnsTopicArn: ZIO[Any, AwsError, SnsTopicArn] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
    def getResourceTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("resourceTags", resourceTags)
    def getInstanceMetadataOptions: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.InstanceMetadataOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "instanceMetadataOptions",
      instanceMetadataOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationRequest
  ) extends zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationRequest.ReadOnly {
    override val infrastructureConfigurationArn
        : InfrastructureConfigurationArn = zio.aws.imagebuilder.model.primitives
      .InfrastructureConfigurationArn(impl.infrastructureConfigurationArn())
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val instanceTypes: Option[List[InstanceType]] = scala
      .Option(impl.instanceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.primitives.InstanceType(item)
        }.toList
      )
    override val instanceProfileName: InstanceProfileNameType =
      zio.aws.imagebuilder.model.primitives
        .InstanceProfileNameType(impl.instanceProfileName())
    override val securityGroupIds: Option[List[NonEmptyString]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val subnetId: Option[NonEmptyString] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val logging: Option[zio.aws.imagebuilder.model.Logging.ReadOnly] =
      scala
        .Option(impl.logging())
        .map(value => zio.aws.imagebuilder.model.Logging.wrap(value))
    override val keyPair: Option[NonEmptyString] = scala
      .Option(impl.keyPair())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val terminateInstanceOnFailure: Option[NullableBoolean] = scala
      .Option(impl.terminateInstanceOnFailure())
      .map(value => value: NullableBoolean)
    override val snsTopicArn: Option[SnsTopicArn] = scala
      .Option(impl.snsTopicArn())
      .map(value => zio.aws.imagebuilder.model.primitives.SnsTopicArn(value))
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
    override val resourceTags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.resourceTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val instanceMetadataOptions
        : Option[zio.aws.imagebuilder.model.InstanceMetadataOptions.ReadOnly] =
      scala
        .Option(impl.instanceMetadataOptions())
        .map(value =>
          zio.aws.imagebuilder.model.InstanceMetadataOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationRequest
  ): zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
