package zio.aws.imagebuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OutputResources(
    amis: Option[Iterable[zio.aws.imagebuilder.model.Ami]] = None,
    containers: Option[Iterable[zio.aws.imagebuilder.model.Container]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.OutputResources = {
    import OutputResources.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.OutputResources
      .builder()
      .optionallyWith(
        amis.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.amis)
      .optionallyWith(
        containers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containers)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.OutputResources.ReadOnly =
    zio.aws.imagebuilder.model.OutputResources.wrap(buildAwsValue())
}
object OutputResources {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.OutputResources
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.OutputResources =
      zio.aws.imagebuilder.model.OutputResources(
        amis.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        containers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def amis: Option[List[zio.aws.imagebuilder.model.Ami.ReadOnly]]
    def containers: Option[List[zio.aws.imagebuilder.model.Container.ReadOnly]]
    def getAmis
        : ZIO[Any, AwsError, List[zio.aws.imagebuilder.model.Ami.ReadOnly]] =
      AwsError.unwrapOptionField("amis", amis)
    def getContainers: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.Container.ReadOnly
    ]] = AwsError.unwrapOptionField("containers", containers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.OutputResources
  ) extends zio.aws.imagebuilder.model.OutputResources.ReadOnly {
    override val amis: Option[List[zio.aws.imagebuilder.model.Ami.ReadOnly]] =
      scala
        .Option(impl.amis())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.Ami.wrap(item)
          }.toList
        )
    override val containers
        : Option[List[zio.aws.imagebuilder.model.Container.ReadOnly]] = scala
      .Option(impl.containers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.Container.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.OutputResources
  ): zio.aws.imagebuilder.model.OutputResources.ReadOnly = new Wrapper(impl)
}
