package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{NonEmptyString, LaunchTemplateId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FastLaunchLaunchTemplateSpecification(
    launchTemplateId: Option[LaunchTemplateId] = None,
    launchTemplateName: Option[NonEmptyString] = None,
    launchTemplateVersion: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.FastLaunchLaunchTemplateSpecification = {
    import FastLaunchLaunchTemplateSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.FastLaunchLaunchTemplateSpecification
      .builder()
      .optionallyWith(
        launchTemplateId.map(value =>
          LaunchTemplateId.unwrap(value): java.lang.String
        )
      )(_.launchTemplateId)
      .optionallyWith(
        launchTemplateName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.launchTemplateName)
      .optionallyWith(
        launchTemplateVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.launchTemplateVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.FastLaunchLaunchTemplateSpecification.ReadOnly =
    zio.aws.imagebuilder.model.FastLaunchLaunchTemplateSpecification
      .wrap(buildAwsValue())
}
object FastLaunchLaunchTemplateSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.FastLaunchLaunchTemplateSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.FastLaunchLaunchTemplateSpecification =
      zio.aws.imagebuilder.model.FastLaunchLaunchTemplateSpecification(
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        launchTemplateVersion.map(value => value)
      )
    def launchTemplateId: Option[LaunchTemplateId]
    def launchTemplateName: Option[NonEmptyString]
    def launchTemplateVersion: Option[NonEmptyString]
    def getLaunchTemplateId: ZIO[Any, AwsError, LaunchTemplateId] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getLaunchTemplateVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("launchTemplateVersion", launchTemplateVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.FastLaunchLaunchTemplateSpecification
  ) extends zio.aws.imagebuilder.model.FastLaunchLaunchTemplateSpecification.ReadOnly {
    override val launchTemplateId: Option[LaunchTemplateId] = scala
      .Option(impl.launchTemplateId())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.LaunchTemplateId(value)
      )
    override val launchTemplateName: Option[NonEmptyString] = scala
      .Option(impl.launchTemplateName())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val launchTemplateVersion: Option[NonEmptyString] = scala
      .Option(impl.launchTemplateVersion())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.FastLaunchLaunchTemplateSpecification
  ): zio.aws.imagebuilder.model.FastLaunchLaunchTemplateSpecification.ReadOnly =
    new Wrapper(impl)
}
