package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ComponentBuildVersionArn,
  ClientToken,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateComponentResponse(
    requestId: Option[NonEmptyString] = None,
    clientToken: Option[ClientToken] = None,
    componentBuildVersionArn: Option[ComponentBuildVersionArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CreateComponentResponse = {
    import CreateComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CreateComponentResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        componentBuildVersionArn.map(value =>
          ComponentBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.componentBuildVersionArn)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.CreateComponentResponse.ReadOnly =
    zio.aws.imagebuilder.model.CreateComponentResponse.wrap(buildAwsValue())
}
object CreateComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CreateComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CreateComponentResponse =
      zio.aws.imagebuilder.model.CreateComponentResponse(
        requestId.map(value => value),
        clientToken.map(value => value),
        componentBuildVersionArn.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def clientToken: Option[ClientToken]
    def componentBuildVersionArn: Option[ComponentBuildVersionArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getComponentBuildVersionArn
        : ZIO[Any, AwsError, ComponentBuildVersionArn] = AwsError
      .unwrapOptionField("componentBuildVersionArn", componentBuildVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateComponentResponse
  ) extends zio.aws.imagebuilder.model.CreateComponentResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.imagebuilder.model.primitives.ClientToken(value))
    override val componentBuildVersionArn: Option[ComponentBuildVersionArn] =
      scala
        .Option(impl.componentBuildVersionArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ComponentBuildVersionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateComponentResponse
  ): zio.aws.imagebuilder.model.CreateComponentResponse.ReadOnly = new Wrapper(
    impl
  )
}
