package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.DistributionConfigurationArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDistributionConfigurationRequest(
    distributionConfigurationArn: DistributionConfigurationArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationRequest = {
    import DeleteDistributionConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationRequest
      .builder()
      .distributionConfigurationArn(
        DistributionConfigurationArn.unwrap(
          distributionConfigurationArn
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.DeleteDistributionConfigurationRequest.ReadOnly =
    zio.aws.imagebuilder.model.DeleteDistributionConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteDistributionConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.DeleteDistributionConfigurationRequest =
      zio.aws.imagebuilder.model
        .DeleteDistributionConfigurationRequest(distributionConfigurationArn)
    def distributionConfigurationArn: DistributionConfigurationArn
    def getDistributionConfigurationArn
        : ZIO[Any, Nothing, DistributionConfigurationArn] =
      ZIO.succeed(distributionConfigurationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationRequest
  ) extends zio.aws.imagebuilder.model.DeleteDistributionConfigurationRequest.ReadOnly {
    override val distributionConfigurationArn: DistributionConfigurationArn =
      zio.aws.imagebuilder.model.primitives
        .DistributionConfigurationArn(impl.distributionConfigurationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationRequest
  ): zio.aws.imagebuilder.model.DeleteDistributionConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
