package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ContainerRecipeArn,
  ClientToken,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateContainerRecipeResponse(
    requestId: Option[NonEmptyString] = None,
    clientToken: Option[ClientToken] = None,
    containerRecipeArn: Option[ContainerRecipeArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeResponse = {
    import CreateContainerRecipeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        containerRecipeArn.map(value =>
          ContainerRecipeArn.unwrap(value): java.lang.String
        )
      )(_.containerRecipeArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.CreateContainerRecipeResponse.ReadOnly =
    zio.aws.imagebuilder.model.CreateContainerRecipeResponse
      .wrap(buildAwsValue())
}
object CreateContainerRecipeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CreateContainerRecipeResponse =
      zio.aws.imagebuilder.model.CreateContainerRecipeResponse(
        requestId.map(value => value),
        clientToken.map(value => value),
        containerRecipeArn.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def clientToken: Option[ClientToken]
    def containerRecipeArn: Option[ContainerRecipeArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getContainerRecipeArn: ZIO[Any, AwsError, ContainerRecipeArn] =
      AwsError.unwrapOptionField("containerRecipeArn", containerRecipeArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeResponse
  ) extends zio.aws.imagebuilder.model.CreateContainerRecipeResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.imagebuilder.model.primitives.ClientToken(value))
    override val containerRecipeArn: Option[ContainerRecipeArn] = scala
      .Option(impl.containerRecipeArn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ContainerRecipeArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeResponse
  ): zio.aws.imagebuilder.model.CreateContainerRecipeResponse.ReadOnly =
    new Wrapper(impl)
}
