package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  AccountId,
  TagValue,
  AmiNameString,
  NonEmptyString,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AmiDistributionConfiguration(
    name: Option[AmiNameString] = None,
    description: Option[NonEmptyString] = None,
    targetAccountIds: Option[Iterable[AccountId]] = None,
    amiTags: Option[Map[TagKey, TagValue]] = None,
    kmsKeyId: Option[NonEmptyString] = None,
    launchPermission: Option[
      zio.aws.imagebuilder.model.LaunchPermissionConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.AmiDistributionConfiguration = {
    import AmiDistributionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.AmiDistributionConfiguration
      .builder()
      .optionallyWith(
        name.map(value => AmiNameString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        targetAccountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetAccountIds)
      .optionallyWith(
        amiTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.amiTags)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(launchPermission.map(value => value.buildAwsValue()))(
        _.launchPermission
      )
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.AmiDistributionConfiguration.ReadOnly =
    zio.aws.imagebuilder.model.AmiDistributionConfiguration
      .wrap(buildAwsValue())
}
object AmiDistributionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.AmiDistributionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.AmiDistributionConfiguration =
      zio.aws.imagebuilder.model.AmiDistributionConfiguration(
        name.map(value => value),
        description.map(value => value),
        targetAccountIds.map(value => value),
        amiTags.map(value => value),
        kmsKeyId.map(value => value),
        launchPermission.map(value => value.asEditable)
      )
    def name: Option[AmiNameString]
    def description: Option[NonEmptyString]
    def targetAccountIds: Option[List[AccountId]]
    def amiTags: Option[Map[TagKey, TagValue]]
    def kmsKeyId: Option[NonEmptyString]
    def launchPermission: Option[
      zio.aws.imagebuilder.model.LaunchPermissionConfiguration.ReadOnly
    ]
    def getName: ZIO[Any, AwsError, AmiNameString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getTargetAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("targetAccountIds", targetAccountIds)
    def getAmiTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("amiTags", amiTags)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getLaunchPermission: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LaunchPermissionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("launchPermission", launchPermission)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.AmiDistributionConfiguration
  ) extends zio.aws.imagebuilder.model.AmiDistributionConfiguration.ReadOnly {
    override val name: Option[AmiNameString] = scala
      .Option(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.AmiNameString(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val targetAccountIds: Option[List[AccountId]] = scala
      .Option(impl.targetAccountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.primitives.AccountId(item)
        }.toList
      )
    override val amiTags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.amiTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val kmsKeyId: Option[NonEmptyString] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val launchPermission: Option[
      zio.aws.imagebuilder.model.LaunchPermissionConfiguration.ReadOnly
    ] = scala
      .Option(impl.launchPermission())
      .map(value =>
        zio.aws.imagebuilder.model.LaunchPermissionConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.AmiDistributionConfiguration
  ): zio.aws.imagebuilder.model.AmiDistributionConfiguration.ReadOnly =
    new Wrapper(impl)
}
