package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  InfrastructureConfigurationArn,
  ClientToken,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateInfrastructureConfigurationResponse(
    requestId: Option[NonEmptyString] = None,
    clientToken: Option[ClientToken] = None,
    infrastructureConfigurationArn: Option[InfrastructureConfigurationArn] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationResponse = {
    import UpdateInfrastructureConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        infrastructureConfigurationArn.map(value =>
          InfrastructureConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.infrastructureConfigurationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse.ReadOnly =
    zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse
      .wrap(buildAwsValue())
}
object UpdateInfrastructureConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse =
      zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse(
        requestId.map(value => value),
        clientToken.map(value => value),
        infrastructureConfigurationArn.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def clientToken: Option[ClientToken]
    def infrastructureConfigurationArn: Option[InfrastructureConfigurationArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getInfrastructureConfigurationArn
        : ZIO[Any, AwsError, InfrastructureConfigurationArn] =
      AwsError.unwrapOptionField(
        "infrastructureConfigurationArn",
        infrastructureConfigurationArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationResponse
  ) extends zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.imagebuilder.model.primitives.ClientToken(value))
    override val infrastructureConfigurationArn
        : Option[InfrastructureConfigurationArn] = scala
      .Option(impl.infrastructureConfigurationArn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives
          .InfrastructureConfigurationArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationResponse
  ): zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
