package zio.aws.imagebuilder.model
import java.lang.Integer
import zio.aws.imagebuilder.model.primitives.{
  PaginationToken,
  RestrictedInteger,
  ImageBuildVersionArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListImagePackagesRequest(
    imageBuildVersionArn: ImageBuildVersionArn,
    maxResults: Option[RestrictedInteger] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest = {
    import ListImagePackagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest
      .builder()
      .imageBuildVersionArn(
        ImageBuildVersionArn.unwrap(imageBuildVersionArn): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => RestrictedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ListImagePackagesRequest.ReadOnly =
    zio.aws.imagebuilder.model.ListImagePackagesRequest.wrap(buildAwsValue())
}
object ListImagePackagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListImagePackagesRequest =
      zio.aws.imagebuilder.model.ListImagePackagesRequest(
        imageBuildVersionArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def imageBuildVersionArn: ImageBuildVersionArn
    def maxResults: Option[RestrictedInteger]
    def nextToken: Option[PaginationToken]
    def getImageBuildVersionArn: ZIO[Any, Nothing, ImageBuildVersionArn] =
      ZIO.succeed(imageBuildVersionArn)
    def getMaxResults: ZIO[Any, AwsError, RestrictedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest
  ) extends zio.aws.imagebuilder.model.ListImagePackagesRequest.ReadOnly {
    override val imageBuildVersionArn: ImageBuildVersionArn =
      zio.aws.imagebuilder.model.primitives
        .ImageBuildVersionArn(impl.imageBuildVersionArn())
    override val maxResults: Option[RestrictedInteger] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.RestrictedInteger(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest
  ): zio.aws.imagebuilder.model.ListImagePackagesRequest.ReadOnly = new Wrapper(
    impl
  )
}
