package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListContainerRecipesResponse(
    requestId: Option[NonEmptyString] = None,
    containerRecipeSummaryList: Option[
      Iterable[zio.aws.imagebuilder.model.ContainerRecipeSummary]
    ] = None,
    nextToken: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse = {
    import ListContainerRecipesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        containerRecipeSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containerRecipeSummaryList)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListContainerRecipesResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListContainerRecipesResponse
      .wrap(buildAwsValue())
}
object ListContainerRecipesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListContainerRecipesResponse =
      zio.aws.imagebuilder.model.ListContainerRecipesResponse(
        requestId.map(value => value),
        containerRecipeSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def containerRecipeSummaryList: Option[
      List[zio.aws.imagebuilder.model.ContainerRecipeSummary.ReadOnly]
    ]
    def nextToken: Option[NonEmptyString]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getContainerRecipeSummaryList: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.ContainerRecipeSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "containerRecipeSummaryList",
      containerRecipeSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse
  ) extends zio.aws.imagebuilder.model.ListContainerRecipesResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val containerRecipeSummaryList: Option[
      List[zio.aws.imagebuilder.model.ContainerRecipeSummary.ReadOnly]
    ] = scala
      .Option(impl.containerRecipeSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.ContainerRecipeSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NonEmptyString] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse
  ): zio.aws.imagebuilder.model.ListContainerRecipesResponse.ReadOnly =
    new Wrapper(impl)
}
