package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ContainerRecipeArn,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutContainerRecipePolicyResponse(
    requestId: Option[NonEmptyString] = None,
    containerRecipeArn: Option[ContainerRecipeArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyResponse = {
    import PutContainerRecipePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        containerRecipeArn.map(value =>
          ContainerRecipeArn.unwrap(value): java.lang.String
        )
      )(_.containerRecipeArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse.ReadOnly =
    zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse
      .wrap(buildAwsValue())
}
object PutContainerRecipePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse =
      zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse(
        requestId.map(value => value),
        containerRecipeArn.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def containerRecipeArn: Option[ContainerRecipeArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getContainerRecipeArn: ZIO[Any, AwsError, ContainerRecipeArn] =
      AwsError.unwrapOptionField("containerRecipeArn", containerRecipeArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyResponse
  ) extends zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val containerRecipeArn: Option[ContainerRecipeArn] = scala
      .Option(impl.containerRecipeArn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ContainerRecipeArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyResponse
  ): zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
