package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImageBuilderArn,
  TagValue,
  DateTime,
  VersionNumber,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImageRecipe(
    arn: Option[ImageBuilderArn] = None,
    `type`: Option[zio.aws.imagebuilder.model.ImageType] = None,
    name: Option[ResourceName] = None,
    description: Option[NonEmptyString] = None,
    platform: Option[zio.aws.imagebuilder.model.Platform] = None,
    owner: Option[NonEmptyString] = None,
    version: Option[VersionNumber] = None,
    components: Option[
      Iterable[zio.aws.imagebuilder.model.ComponentConfiguration]
    ] = None,
    parentImage: Option[NonEmptyString] = None,
    blockDeviceMappings: Option[
      Iterable[zio.aws.imagebuilder.model.InstanceBlockDeviceMapping]
    ] = None,
    dateCreated: Option[DateTime] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    workingDirectory: Option[NonEmptyString] = None,
    additionalInstanceConfiguration: Option[
      zio.aws.imagebuilder.model.AdditionalInstanceConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImageRecipe = {
    import ImageRecipe.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImageRecipe
      .builder()
      .optionallyWith(
        arn.map(value => ImageBuilderArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        owner.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        version.map(value => VersionNumber.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        components.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.components)
      .optionallyWith(
        parentImage.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.parentImage)
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        workingDirectory.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.workingDirectory)
      .optionallyWith(
        additionalInstanceConfiguration.map(value => value.buildAwsValue())
      )(_.additionalInstanceConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ImageRecipe.ReadOnly =
    zio.aws.imagebuilder.model.ImageRecipe.wrap(buildAwsValue())
}
object ImageRecipe {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImageRecipe
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImageRecipe =
      zio.aws.imagebuilder.model.ImageRecipe(
        arn.map(value => value),
        `type`.map(value => value),
        name.map(value => value),
        description.map(value => value),
        platform.map(value => value),
        owner.map(value => value),
        version.map(value => value),
        components.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        parentImage.map(value => value),
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dateCreated.map(value => value),
        tags.map(value => value),
        workingDirectory.map(value => value),
        additionalInstanceConfiguration.map(value => value.asEditable)
      )
    def arn: Option[ImageBuilderArn]
    def `type`: Option[zio.aws.imagebuilder.model.ImageType]
    def name: Option[ResourceName]
    def description: Option[NonEmptyString]
    def platform: Option[zio.aws.imagebuilder.model.Platform]
    def owner: Option[NonEmptyString]
    def version: Option[VersionNumber]
    def components: Option[
      List[zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly]
    ]
    def parentImage: Option[NonEmptyString]
    def blockDeviceMappings: Option[
      List[zio.aws.imagebuilder.model.InstanceBlockDeviceMapping.ReadOnly]
    ]
    def dateCreated: Option[DateTime]
    def tags: Option[Map[TagKey, TagValue]]
    def workingDirectory: Option[NonEmptyString]
    def additionalInstanceConfiguration: Option[
      zio.aws.imagebuilder.model.AdditionalInstanceConfiguration.ReadOnly
    ]
    def getArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, zio.aws.imagebuilder.model.ImageType] =
      AwsError.unwrapOptionField("type", `type`)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getPlatform: ZIO[Any, AwsError, zio.aws.imagebuilder.model.Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getOwner: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("owner", owner)
    def getVersion: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getComponents: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("components", components)
    def getParentImage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("parentImage", parentImage)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.InstanceBlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorkingDirectory: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("workingDirectory", workingDirectory)
    def getAdditionalInstanceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.AdditionalInstanceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "additionalInstanceConfiguration",
      additionalInstanceConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageRecipe
  ) extends zio.aws.imagebuilder.model.ImageRecipe.ReadOnly {
    override val arn: Option[ImageBuilderArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val `type`: Option[zio.aws.imagebuilder.model.ImageType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.imagebuilder.model.ImageType.wrap(value))
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val platform: Option[zio.aws.imagebuilder.model.Platform] = scala
      .Option(impl.platform())
      .map(value => zio.aws.imagebuilder.model.Platform.wrap(value))
    override val owner: Option[NonEmptyString] = scala
      .Option(impl.owner())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val version: Option[VersionNumber] = scala
      .Option(impl.version())
      .map(value => zio.aws.imagebuilder.model.primitives.VersionNumber(value))
    override val components: Option[
      List[zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly]
    ] = scala
      .Option(impl.components())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.ComponentConfiguration.wrap(item)
        }.toList
      )
    override val parentImage: Option[NonEmptyString] = scala
      .Option(impl.parentImage())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val blockDeviceMappings: Option[
      List[zio.aws.imagebuilder.model.InstanceBlockDeviceMapping.ReadOnly]
    ] = scala
      .Option(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.InstanceBlockDeviceMapping.wrap(item)
        }.toList
      )
    override val dateCreated: Option[DateTime] = scala
      .Option(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val workingDirectory: Option[NonEmptyString] = scala
      .Option(impl.workingDirectory())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val additionalInstanceConfiguration: Option[
      zio.aws.imagebuilder.model.AdditionalInstanceConfiguration.ReadOnly
    ] = scala
      .Option(impl.additionalInstanceConfiguration())
      .map(value =>
        zio.aws.imagebuilder.model.AdditionalInstanceConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageRecipe
  ): zio.aws.imagebuilder.model.ImageRecipe.ReadOnly = new Wrapper(impl)
}
