package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  DistributionConfigurationArn,
  ImageRecipeArn,
  InfrastructureConfigurationArn,
  TagValue,
  ClientToken,
  ContainerRecipeArn,
  NullableBoolean,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateImageRequest(
    imageRecipeArn: Option[ImageRecipeArn] = None,
    containerRecipeArn: Option[ContainerRecipeArn] = None,
    distributionConfigurationArn: Option[DistributionConfigurationArn] = None,
    infrastructureConfigurationArn: InfrastructureConfigurationArn,
    imageTestsConfiguration: Option[
      zio.aws.imagebuilder.model.ImageTestsConfiguration
    ] = None,
    enhancedImageMetadataEnabled: Option[NullableBoolean] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CreateImageRequest = {
    import CreateImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CreateImageRequest
      .builder()
      .optionallyWith(
        imageRecipeArn.map(value =>
          ImageRecipeArn.unwrap(value): java.lang.String
        )
      )(_.imageRecipeArn)
      .optionallyWith(
        containerRecipeArn.map(value =>
          ContainerRecipeArn.unwrap(value): java.lang.String
        )
      )(_.containerRecipeArn)
      .optionallyWith(
        distributionConfigurationArn.map(value =>
          DistributionConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.distributionConfigurationArn)
      .infrastructureConfigurationArn(
        InfrastructureConfigurationArn.unwrap(
          infrastructureConfigurationArn
        ): java.lang.String
      )
      .optionallyWith(
        imageTestsConfiguration.map(value => value.buildAwsValue())
      )(_.imageTestsConfiguration)
      .optionallyWith(
        enhancedImageMetadataEnabled.map(value => value: java.lang.Boolean)
      )(_.enhancedImageMetadataEnabled)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.CreateImageRequest.ReadOnly =
    zio.aws.imagebuilder.model.CreateImageRequest.wrap(buildAwsValue())
}
object CreateImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CreateImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CreateImageRequest =
      zio.aws.imagebuilder.model.CreateImageRequest(
        imageRecipeArn.map(value => value),
        containerRecipeArn.map(value => value),
        distributionConfigurationArn.map(value => value),
        infrastructureConfigurationArn,
        imageTestsConfiguration.map(value => value.asEditable),
        enhancedImageMetadataEnabled.map(value => value),
        tags.map(value => value),
        clientToken
      )
    def imageRecipeArn: Option[ImageRecipeArn]
    def containerRecipeArn: Option[ContainerRecipeArn]
    def distributionConfigurationArn: Option[DistributionConfigurationArn]
    def infrastructureConfigurationArn: InfrastructureConfigurationArn
    def imageTestsConfiguration
        : Option[zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly]
    def enhancedImageMetadataEnabled: Option[NullableBoolean]
    def tags: Option[Map[TagKey, TagValue]]
    def clientToken: ClientToken
    def getImageRecipeArn: ZIO[Any, AwsError, ImageRecipeArn] =
      AwsError.unwrapOptionField("imageRecipeArn", imageRecipeArn)
    def getContainerRecipeArn: ZIO[Any, AwsError, ContainerRecipeArn] =
      AwsError.unwrapOptionField("containerRecipeArn", containerRecipeArn)
    def getDistributionConfigurationArn
        : ZIO[Any, AwsError, DistributionConfigurationArn] =
      AwsError.unwrapOptionField(
        "distributionConfigurationArn",
        distributionConfigurationArn
      )
    def getInfrastructureConfigurationArn
        : ZIO[Any, Nothing, InfrastructureConfigurationArn] =
      ZIO.succeed(infrastructureConfigurationArn)
    def getImageTestsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "imageTestsConfiguration",
      imageTestsConfiguration
    )
    def getEnhancedImageMetadataEnabled: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField(
        "enhancedImageMetadataEnabled",
        enhancedImageMetadataEnabled
      )
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateImageRequest
  ) extends zio.aws.imagebuilder.model.CreateImageRequest.ReadOnly {
    override val imageRecipeArn: Option[ImageRecipeArn] = scala
      .Option(impl.imageRecipeArn())
      .map(value => zio.aws.imagebuilder.model.primitives.ImageRecipeArn(value))
    override val containerRecipeArn: Option[ContainerRecipeArn] = scala
      .Option(impl.containerRecipeArn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ContainerRecipeArn(value)
      )
    override val distributionConfigurationArn
        : Option[DistributionConfigurationArn] = scala
      .Option(impl.distributionConfigurationArn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives
          .DistributionConfigurationArn(value)
      )
    override val infrastructureConfigurationArn
        : InfrastructureConfigurationArn = zio.aws.imagebuilder.model.primitives
      .InfrastructureConfigurationArn(impl.infrastructureConfigurationArn())
    override val imageTestsConfiguration
        : Option[zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly] =
      scala
        .Option(impl.imageTestsConfiguration())
        .map(value =>
          zio.aws.imagebuilder.model.ImageTestsConfiguration.wrap(value)
        )
    override val enhancedImageMetadataEnabled: Option[NullableBoolean] = scala
      .Option(impl.enhancedImageMetadataEnabled())
      .map(value => value: NullableBoolean)
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateImageRequest
  ): zio.aws.imagebuilder.model.CreateImageRequest.ReadOnly = new Wrapper(impl)
}
