package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImageBuilderArn,
  TagValue,
  DateTime,
  VersionNumber,
  DockerFileTemplate,
  NullableBoolean,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ContainerRecipe(
    arn: Option[ImageBuilderArn] = None,
    containerType: Option[zio.aws.imagebuilder.model.ContainerType] = None,
    name: Option[ResourceName] = None,
    description: Option[NonEmptyString] = None,
    platform: Option[zio.aws.imagebuilder.model.Platform] = None,
    owner: Option[NonEmptyString] = None,
    version: Option[VersionNumber] = None,
    components: Option[
      Iterable[zio.aws.imagebuilder.model.ComponentConfiguration]
    ] = None,
    instanceConfiguration: Option[
      zio.aws.imagebuilder.model.InstanceConfiguration
    ] = None,
    dockerfileTemplateData: Option[DockerFileTemplate] = None,
    kmsKeyId: Option[NonEmptyString] = None,
    encrypted: Option[NullableBoolean] = None,
    parentImage: Option[NonEmptyString] = None,
    dateCreated: Option[DateTime] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    workingDirectory: Option[NonEmptyString] = None,
    targetRepository: Option[
      zio.aws.imagebuilder.model.TargetContainerRepository
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ContainerRecipe = {
    import ContainerRecipe.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ContainerRecipe
      .builder()
      .optionallyWith(
        arn.map(value => ImageBuilderArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(containerType.map(value => value.unwrap))(_.containerType)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        owner.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        version.map(value => VersionNumber.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        components.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.components)
      .optionallyWith(
        instanceConfiguration.map(value => value.buildAwsValue())
      )(_.instanceConfiguration)
      .optionallyWith(
        dockerfileTemplateData.map(value =>
          DockerFileTemplate.unwrap(value): java.lang.String
        )
      )(_.dockerfileTemplateData)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(
        parentImage.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.parentImage)
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        workingDirectory.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.workingDirectory)
      .optionallyWith(targetRepository.map(value => value.buildAwsValue()))(
        _.targetRepository
      )
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ContainerRecipe.ReadOnly =
    zio.aws.imagebuilder.model.ContainerRecipe.wrap(buildAwsValue())
}
object ContainerRecipe {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ContainerRecipe
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ContainerRecipe =
      zio.aws.imagebuilder.model.ContainerRecipe(
        arn.map(value => value),
        containerType.map(value => value),
        name.map(value => value),
        description.map(value => value),
        platform.map(value => value),
        owner.map(value => value),
        version.map(value => value),
        components.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceConfiguration.map(value => value.asEditable),
        dockerfileTemplateData.map(value => value),
        kmsKeyId.map(value => value),
        encrypted.map(value => value),
        parentImage.map(value => value),
        dateCreated.map(value => value),
        tags.map(value => value),
        workingDirectory.map(value => value),
        targetRepository.map(value => value.asEditable)
      )
    def arn: Option[ImageBuilderArn]
    def containerType: Option[zio.aws.imagebuilder.model.ContainerType]
    def name: Option[ResourceName]
    def description: Option[NonEmptyString]
    def platform: Option[zio.aws.imagebuilder.model.Platform]
    def owner: Option[NonEmptyString]
    def version: Option[VersionNumber]
    def components: Option[
      List[zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly]
    ]
    def instanceConfiguration
        : Option[zio.aws.imagebuilder.model.InstanceConfiguration.ReadOnly]
    def dockerfileTemplateData: Option[DockerFileTemplate]
    def kmsKeyId: Option[NonEmptyString]
    def encrypted: Option[NullableBoolean]
    def parentImage: Option[NonEmptyString]
    def dateCreated: Option[DateTime]
    def tags: Option[Map[TagKey, TagValue]]
    def workingDirectory: Option[NonEmptyString]
    def targetRepository
        : Option[zio.aws.imagebuilder.model.TargetContainerRepository.ReadOnly]
    def getArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getContainerType
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.ContainerType] =
      AwsError.unwrapOptionField("containerType", containerType)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getPlatform: ZIO[Any, AwsError, zio.aws.imagebuilder.model.Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getOwner: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("owner", owner)
    def getVersion: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getComponents: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("components", components)
    def getInstanceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.InstanceConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("instanceConfiguration", instanceConfiguration)
    def getDockerfileTemplateData: ZIO[Any, AwsError, DockerFileTemplate] =
      AwsError.unwrapOptionField(
        "dockerfileTemplateData",
        dockerfileTemplateData
      )
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEncrypted: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getParentImage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("parentImage", parentImage)
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorkingDirectory: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("workingDirectory", workingDirectory)
    def getTargetRepository: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.TargetContainerRepository.ReadOnly
    ] = AwsError.unwrapOptionField("targetRepository", targetRepository)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ContainerRecipe
  ) extends zio.aws.imagebuilder.model.ContainerRecipe.ReadOnly {
    override val arn: Option[ImageBuilderArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val containerType
        : Option[zio.aws.imagebuilder.model.ContainerType] = scala
      .Option(impl.containerType())
      .map(value => zio.aws.imagebuilder.model.ContainerType.wrap(value))
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val platform: Option[zio.aws.imagebuilder.model.Platform] = scala
      .Option(impl.platform())
      .map(value => zio.aws.imagebuilder.model.Platform.wrap(value))
    override val owner: Option[NonEmptyString] = scala
      .Option(impl.owner())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val version: Option[VersionNumber] = scala
      .Option(impl.version())
      .map(value => zio.aws.imagebuilder.model.primitives.VersionNumber(value))
    override val components: Option[
      List[zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly]
    ] = scala
      .Option(impl.components())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.ComponentConfiguration.wrap(item)
        }.toList
      )
    override val instanceConfiguration
        : Option[zio.aws.imagebuilder.model.InstanceConfiguration.ReadOnly] =
      scala
        .Option(impl.instanceConfiguration())
        .map(value =>
          zio.aws.imagebuilder.model.InstanceConfiguration.wrap(value)
        )
    override val dockerfileTemplateData: Option[DockerFileTemplate] = scala
      .Option(impl.dockerfileTemplateData())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.DockerFileTemplate(value)
      )
    override val kmsKeyId: Option[NonEmptyString] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val encrypted: Option[NullableBoolean] =
      scala.Option(impl.encrypted()).map(value => value: NullableBoolean)
    override val parentImage: Option[NonEmptyString] = scala
      .Option(impl.parentImage())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val dateCreated: Option[DateTime] = scala
      .Option(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val workingDirectory: Option[NonEmptyString] = scala
      .Option(impl.workingDirectory())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val targetRepository: Option[
      zio.aws.imagebuilder.model.TargetContainerRepository.ReadOnly
    ] = scala
      .Option(impl.targetRepository())
      .map(value =>
        zio.aws.imagebuilder.model.TargetContainerRepository.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ContainerRecipe
  ): zio.aws.imagebuilder.model.ContainerRecipe.ReadOnly = new Wrapper(impl)
}
