package zio.aws.imagebuilder.model
import java.lang.Integer
import zio.aws.imagebuilder.model.primitives.{
  PaginationToken,
  RestrictedInteger,
  ImageVersionArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListImageBuildVersionsRequest(
    imageVersionArn: ImageVersionArn,
    filters: Option[Iterable[zio.aws.imagebuilder.model.Filter]] = None,
    maxResults: Option[RestrictedInteger] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest = {
    import ListImageBuildVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest
      .builder()
      .imageVersionArn(
        ImageVersionArn.unwrap(imageVersionArn): java.lang.String
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => RestrictedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListImageBuildVersionsRequest.ReadOnly =
    zio.aws.imagebuilder.model.ListImageBuildVersionsRequest
      .wrap(buildAwsValue())
}
object ListImageBuildVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListImageBuildVersionsRequest =
      zio.aws.imagebuilder.model.ListImageBuildVersionsRequest(
        imageVersionArn,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def imageVersionArn: ImageVersionArn
    def filters: Option[List[zio.aws.imagebuilder.model.Filter.ReadOnly]]
    def maxResults: Option[RestrictedInteger]
    def nextToken: Option[PaginationToken]
    def getImageVersionArn: ZIO[Any, Nothing, ImageVersionArn] =
      ZIO.succeed(imageVersionArn)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.imagebuilder.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, RestrictedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest
  ) extends zio.aws.imagebuilder.model.ListImageBuildVersionsRequest.ReadOnly {
    override val imageVersionArn: ImageVersionArn =
      zio.aws.imagebuilder.model.primitives
        .ImageVersionArn(impl.imageVersionArn())
    override val filters
        : Option[List[zio.aws.imagebuilder.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.Filter.wrap(item)
        }.toList
      )
    override val maxResults: Option[RestrictedInteger] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.RestrictedInteger(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest
  ): zio.aws.imagebuilder.model.ListImageBuildVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
