package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters._
sealed trait PipelineStatus {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.PipelineStatus
}
object PipelineStatus {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.PipelineStatus
  ): zio.aws.imagebuilder.model.PipelineStatus = value match {
    case software.amazon.awssdk.services.imagebuilder.model.PipelineStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.PipelineStatus.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.imagebuilder.model.PipelineStatus.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.PipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.PipelineStatus =
      software.amazon.awssdk.services.imagebuilder.model.PipelineStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.imagebuilder.model.PipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.PipelineStatus =
      software.amazon.awssdk.services.imagebuilder.model.PipelineStatus.DISABLED
  }
  case object ENABLED extends zio.aws.imagebuilder.model.PipelineStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.PipelineStatus =
      software.amazon.awssdk.services.imagebuilder.model.PipelineStatus.ENABLED
  }
}
