package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{PaginationToken, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDistributionConfigurationsResponse(
    requestId: Option[NonEmptyString] = None,
    distributionConfigurationSummaryList: Option[
      Iterable[zio.aws.imagebuilder.model.DistributionConfigurationSummary]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse = {
    import ListDistributionConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        distributionConfigurationSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.distributionConfigurationSummaryList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListDistributionConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse =
      zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse(
        requestId.map(value => value),
        distributionConfigurationSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def distributionConfigurationSummaryList: Option[
      List[zio.aws.imagebuilder.model.DistributionConfigurationSummary.ReadOnly]
    ]
    def nextToken: Option[PaginationToken]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getDistributionConfigurationSummaryList: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.DistributionConfigurationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "distributionConfigurationSummaryList",
      distributionConfigurationSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse
  ) extends zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val distributionConfigurationSummaryList: Option[
      List[zio.aws.imagebuilder.model.DistributionConfigurationSummary.ReadOnly]
    ] = scala
      .Option(impl.distributionConfigurationSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.DistributionConfigurationSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsResponse
  ): zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
