package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImageBuilderArn,
  TagValue,
  DateTime,
  VersionNumber,
  OsVersion,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImageSummary(
    arn: Option[ImageBuilderArn] = None,
    name: Option[ResourceName] = None,
    `type`: Option[zio.aws.imagebuilder.model.ImageType] = None,
    version: Option[VersionNumber] = None,
    platform: Option[zio.aws.imagebuilder.model.Platform] = None,
    osVersion: Option[OsVersion] = None,
    state: Option[zio.aws.imagebuilder.model.ImageState] = None,
    owner: Option[NonEmptyString] = None,
    dateCreated: Option[DateTime] = None,
    outputResources: Option[zio.aws.imagebuilder.model.OutputResources] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    buildType: Option[zio.aws.imagebuilder.model.BuildType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImageSummary = {
    import ImageSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImageSummary
      .builder()
      .optionallyWith(
        arn.map(value => ImageBuilderArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        version.map(value => VersionNumber.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        osVersion.map(value => OsVersion.unwrap(value): java.lang.String)
      )(_.osVersion)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(
        owner.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(outputResources.map(value => value.buildAwsValue()))(
        _.outputResources
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(buildType.map(value => value.unwrap))(_.buildType)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ImageSummary.ReadOnly =
    zio.aws.imagebuilder.model.ImageSummary.wrap(buildAwsValue())
}
object ImageSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImageSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImageSummary =
      zio.aws.imagebuilder.model.ImageSummary(
        arn.map(value => value),
        name.map(value => value),
        `type`.map(value => value),
        version.map(value => value),
        platform.map(value => value),
        osVersion.map(value => value),
        state.map(value => value.asEditable),
        owner.map(value => value),
        dateCreated.map(value => value),
        outputResources.map(value => value.asEditable),
        tags.map(value => value),
        buildType.map(value => value)
      )
    def arn: Option[ImageBuilderArn]
    def name: Option[ResourceName]
    def `type`: Option[zio.aws.imagebuilder.model.ImageType]
    def version: Option[VersionNumber]
    def platform: Option[zio.aws.imagebuilder.model.Platform]
    def osVersion: Option[OsVersion]
    def state: Option[zio.aws.imagebuilder.model.ImageState.ReadOnly]
    def owner: Option[NonEmptyString]
    def dateCreated: Option[DateTime]
    def outputResources
        : Option[zio.aws.imagebuilder.model.OutputResources.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def buildType: Option[zio.aws.imagebuilder.model.BuildType]
    def getArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.imagebuilder.model.ImageType] =
      AwsError.unwrapOptionField("type", `type`)
    def getVersion: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getPlatform: ZIO[Any, AwsError, zio.aws.imagebuilder.model.Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getOsVersion: ZIO[Any, AwsError, OsVersion] =
      AwsError.unwrapOptionField("osVersion", osVersion)
    def getState
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.ImageState.ReadOnly] =
      AwsError.unwrapOptionField("state", state)
    def getOwner: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("owner", owner)
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getOutputResources: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.OutputResources.ReadOnly
    ] = AwsError.unwrapOptionField("outputResources", outputResources)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getBuildType: ZIO[Any, AwsError, zio.aws.imagebuilder.model.BuildType] =
      AwsError.unwrapOptionField("buildType", buildType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageSummary
  ) extends zio.aws.imagebuilder.model.ImageSummary.ReadOnly {
    override val arn: Option[ImageBuilderArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val `type`: Option[zio.aws.imagebuilder.model.ImageType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.imagebuilder.model.ImageType.wrap(value))
    override val version: Option[VersionNumber] = scala
      .Option(impl.version())
      .map(value => zio.aws.imagebuilder.model.primitives.VersionNumber(value))
    override val platform: Option[zio.aws.imagebuilder.model.Platform] = scala
      .Option(impl.platform())
      .map(value => zio.aws.imagebuilder.model.Platform.wrap(value))
    override val osVersion: Option[OsVersion] = scala
      .Option(impl.osVersion())
      .map(value => zio.aws.imagebuilder.model.primitives.OsVersion(value))
    override val state: Option[zio.aws.imagebuilder.model.ImageState.ReadOnly] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.imagebuilder.model.ImageState.wrap(value))
    override val owner: Option[NonEmptyString] = scala
      .Option(impl.owner())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val dateCreated: Option[DateTime] = scala
      .Option(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val outputResources
        : Option[zio.aws.imagebuilder.model.OutputResources.ReadOnly] = scala
      .Option(impl.outputResources())
      .map(value => zio.aws.imagebuilder.model.OutputResources.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val buildType: Option[zio.aws.imagebuilder.model.BuildType] = scala
      .Option(impl.buildType())
      .map(value => zio.aws.imagebuilder.model.BuildType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageSummary
  ): zio.aws.imagebuilder.model.ImageSummary.ReadOnly = new Wrapper(impl)
}
