package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{ImageRecipeArn, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteImageRecipeResponse(
    requestId: Option[NonEmptyString] = None,
    imageRecipeArn: Option[ImageRecipeArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeResponse = {
    import DeleteImageRecipeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        imageRecipeArn.map(value =>
          ImageRecipeArn.unwrap(value): java.lang.String
        )
      )(_.imageRecipeArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.DeleteImageRecipeResponse.ReadOnly =
    zio.aws.imagebuilder.model.DeleteImageRecipeResponse.wrap(buildAwsValue())
}
object DeleteImageRecipeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.DeleteImageRecipeResponse =
      zio.aws.imagebuilder.model.DeleteImageRecipeResponse(
        requestId.map(value => value),
        imageRecipeArn.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def imageRecipeArn: Option[ImageRecipeArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getImageRecipeArn: ZIO[Any, AwsError, ImageRecipeArn] =
      AwsError.unwrapOptionField("imageRecipeArn", imageRecipeArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeResponse
  ) extends zio.aws.imagebuilder.model.DeleteImageRecipeResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imageRecipeArn: Option[ImageRecipeArn] = scala
      .Option(impl.imageRecipeArn())
      .map(value => zio.aws.imagebuilder.model.primitives.ImageRecipeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeResponse
  ): zio.aws.imagebuilder.model.DeleteImageRecipeResponse.ReadOnly =
    new Wrapper(impl)
}
