package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  DistributionConfigurationArn,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteDistributionConfigurationResponse(
    requestId: Option[NonEmptyString] = None,
    distributionConfigurationArn: Option[DistributionConfigurationArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationResponse = {
    import DeleteDistributionConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        distributionConfigurationArn.map(value =>
          DistributionConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.distributionConfigurationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse.ReadOnly =
    zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse
      .wrap(buildAwsValue())
}
object DeleteDistributionConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse =
      zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse(
        requestId.map(value => value),
        distributionConfigurationArn.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def distributionConfigurationArn: Option[DistributionConfigurationArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getDistributionConfigurationArn
        : ZIO[Any, AwsError, DistributionConfigurationArn] =
      AwsError.unwrapOptionField(
        "distributionConfigurationArn",
        distributionConfigurationArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationResponse
  ) extends zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val distributionConfigurationArn
        : Option[DistributionConfigurationArn] = scala
      .Option(impl.distributionConfigurationArn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives
          .DistributionConfigurationArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationResponse
  ): zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
