package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{AccountId, LaunchTemplateId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateConfiguration(
    launchTemplateId: LaunchTemplateId,
    accountId: Option[AccountId] = None,
    setDefaultVersion: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.LaunchTemplateConfiguration = {
    import LaunchTemplateConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.LaunchTemplateConfiguration
      .builder()
      .launchTemplateId(
        LaunchTemplateId.unwrap(launchTemplateId): java.lang.String
      )
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(setDefaultVersion.map(value => value: java.lang.Boolean))(
        _.setDefaultVersion
      )
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.LaunchTemplateConfiguration.ReadOnly =
    zio.aws.imagebuilder.model.LaunchTemplateConfiguration.wrap(buildAwsValue())
}
object LaunchTemplateConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.LaunchTemplateConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.LaunchTemplateConfiguration =
      zio.aws.imagebuilder.model.LaunchTemplateConfiguration(
        launchTemplateId,
        accountId.map(value => value),
        setDefaultVersion.map(value => value)
      )
    def launchTemplateId: LaunchTemplateId
    def accountId: Option[AccountId]
    def setDefaultVersion: Option[Boolean]
    def getLaunchTemplateId: ZIO[Any, Nothing, LaunchTemplateId] =
      ZIO.succeed(launchTemplateId)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getSetDefaultVersion: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("setDefaultVersion", setDefaultVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.LaunchTemplateConfiguration
  ) extends zio.aws.imagebuilder.model.LaunchTemplateConfiguration.ReadOnly {
    override val launchTemplateId: LaunchTemplateId =
      zio.aws.imagebuilder.model.primitives
        .LaunchTemplateId(impl.launchTemplateId())
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.imagebuilder.model.primitives.AccountId(value))
    override val setDefaultVersion: Option[Boolean] =
      scala.Option(impl.setDefaultVersion()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.LaunchTemplateConfiguration
  ): zio.aws.imagebuilder.model.LaunchTemplateConfiguration.ReadOnly =
    new Wrapper(impl)
}
