package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.ComponentBuildVersionArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteComponentRequest(
    componentBuildVersionArn: ComponentBuildVersionArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.DeleteComponentRequest = {
    import DeleteComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.DeleteComponentRequest
      .builder()
      .componentBuildVersionArn(
        ComponentBuildVersionArn.unwrap(
          componentBuildVersionArn
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.DeleteComponentRequest.ReadOnly =
    zio.aws.imagebuilder.model.DeleteComponentRequest.wrap(buildAwsValue())
}
object DeleteComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.DeleteComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.DeleteComponentRequest =
      zio.aws.imagebuilder.model
        .DeleteComponentRequest(componentBuildVersionArn)
    def componentBuildVersionArn: ComponentBuildVersionArn
    def getComponentBuildVersionArn
        : ZIO[Any, Nothing, ComponentBuildVersionArn] =
      ZIO.succeed(componentBuildVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteComponentRequest
  ) extends zio.aws.imagebuilder.model.DeleteComponentRequest.ReadOnly {
    override val componentBuildVersionArn: ComponentBuildVersionArn =
      zio.aws.imagebuilder.model.primitives
        .ComponentBuildVersionArn(impl.componentBuildVersionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteComponentRequest
  ): zio.aws.imagebuilder.model.DeleteComponentRequest.ReadOnly = new Wrapper(
    impl
  )
}
