package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ComponentBuildVersionArn,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutComponentPolicyResponse(
    requestId: Option[NonEmptyString] = None,
    componentArn: Option[ComponentBuildVersionArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyResponse = {
    import PutComponentPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        componentArn.map(value =>
          ComponentBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.componentArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.PutComponentPolicyResponse.ReadOnly =
    zio.aws.imagebuilder.model.PutComponentPolicyResponse.wrap(buildAwsValue())
}
object PutComponentPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.PutComponentPolicyResponse =
      zio.aws.imagebuilder.model.PutComponentPolicyResponse(
        requestId.map(value => value),
        componentArn.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def componentArn: Option[ComponentBuildVersionArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getComponentArn: ZIO[Any, AwsError, ComponentBuildVersionArn] =
      AwsError.unwrapOptionField("componentArn", componentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyResponse
  ) extends zio.aws.imagebuilder.model.PutComponentPolicyResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val componentArn: Option[ComponentBuildVersionArn] = scala
      .Option(impl.componentArn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ComponentBuildVersionArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyResponse
  ): zio.aws.imagebuilder.model.PutComponentPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
