package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetContainerRecipeResponse(
    requestId: Option[NonEmptyString] = None,
    containerRecipe: Option[zio.aws.imagebuilder.model.ContainerRecipe] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeResponse = {
    import GetContainerRecipeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(containerRecipe.map(value => value.buildAwsValue()))(
        _.containerRecipe
      )
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.GetContainerRecipeResponse.ReadOnly =
    zio.aws.imagebuilder.model.GetContainerRecipeResponse.wrap(buildAwsValue())
}
object GetContainerRecipeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.GetContainerRecipeResponse =
      zio.aws.imagebuilder.model.GetContainerRecipeResponse(
        requestId.map(value => value),
        containerRecipe.map(value => value.asEditable)
      )
    def requestId: Option[NonEmptyString]
    def containerRecipe
        : Option[zio.aws.imagebuilder.model.ContainerRecipe.ReadOnly]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getContainerRecipe: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ContainerRecipe.ReadOnly
    ] = AwsError.unwrapOptionField("containerRecipe", containerRecipe)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeResponse
  ) extends zio.aws.imagebuilder.model.GetContainerRecipeResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val containerRecipe
        : Option[zio.aws.imagebuilder.model.ContainerRecipe.ReadOnly] = scala
      .Option(impl.containerRecipe())
      .map(value => zio.aws.imagebuilder.model.ContainerRecipe.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeResponse
  ): zio.aws.imagebuilder.model.GetContainerRecipeResponse.ReadOnly =
    new Wrapper(impl)
}
