package zio.aws.imagebuilder.model
import java.lang.Integer
import zio.aws.imagebuilder.model.primitives.{NonEmptyString, RestrictedInteger}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListContainerRecipesRequest(
    owner: Option[zio.aws.imagebuilder.model.Ownership] = None,
    filters: Option[Iterable[zio.aws.imagebuilder.model.Filter]] = None,
    maxResults: Option[RestrictedInteger] = None,
    nextToken: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest = {
    import ListContainerRecipesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest
      .builder()
      .optionallyWith(owner.map(value => value.unwrap))(_.owner)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => RestrictedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListContainerRecipesRequest.ReadOnly =
    zio.aws.imagebuilder.model.ListContainerRecipesRequest.wrap(buildAwsValue())
}
object ListContainerRecipesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListContainerRecipesRequest =
      zio.aws.imagebuilder.model.ListContainerRecipesRequest(
        owner.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def owner: Option[zio.aws.imagebuilder.model.Ownership]
    def filters: Option[List[zio.aws.imagebuilder.model.Filter.ReadOnly]]
    def maxResults: Option[RestrictedInteger]
    def nextToken: Option[NonEmptyString]
    def getOwner: ZIO[Any, AwsError, zio.aws.imagebuilder.model.Ownership] =
      AwsError.unwrapOptionField("owner", owner)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.imagebuilder.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, RestrictedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest
  ) extends zio.aws.imagebuilder.model.ListContainerRecipesRequest.ReadOnly {
    override val owner: Option[zio.aws.imagebuilder.model.Ownership] = scala
      .Option(impl.owner())
      .map(value => zio.aws.imagebuilder.model.Ownership.wrap(value))
    override val filters
        : Option[List[zio.aws.imagebuilder.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.Filter.wrap(item)
        }.toList
      )
    override val maxResults: Option[RestrictedInteger] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.RestrictedInteger(value)
      )
    override val nextToken: Option[NonEmptyString] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest
  ): zio.aws.imagebuilder.model.ListContainerRecipesRequest.ReadOnly =
    new Wrapper(impl)
}
