package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImageState(
    status: Option[zio.aws.imagebuilder.model.ImageStatus] = None,
    reason: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImageState = {
    import ImageState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImageState
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        reason.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ImageState.ReadOnly =
    zio.aws.imagebuilder.model.ImageState.wrap(buildAwsValue())
}
object ImageState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImageState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImageState =
      zio.aws.imagebuilder.model
        .ImageState(status.map(value => value), reason.map(value => value))
    def status: Option[zio.aws.imagebuilder.model.ImageStatus]
    def reason: Option[NonEmptyString]
    def getStatus: ZIO[Any, AwsError, zio.aws.imagebuilder.model.ImageStatus] =
      AwsError.unwrapOptionField("status", status)
    def getReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageState
  ) extends zio.aws.imagebuilder.model.ImageState.ReadOnly {
    override val status: Option[zio.aws.imagebuilder.model.ImageStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.imagebuilder.model.ImageStatus.wrap(value))
    override val reason: Option[NonEmptyString] = scala
      .Option(impl.reason())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageState
  ): zio.aws.imagebuilder.model.ImageState.ReadOnly = new Wrapper(impl)
}
