package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImageBuilderArn,
  TagValue,
  Arn,
  DateTime,
  NullableBoolean,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImagePipeline(
    arn: Option[ImageBuilderArn] = None,
    name: Option[ResourceName] = None,
    description: Option[NonEmptyString] = None,
    platform: Option[zio.aws.imagebuilder.model.Platform] = None,
    enhancedImageMetadataEnabled: Option[NullableBoolean] = None,
    imageRecipeArn: Option[Arn] = None,
    containerRecipeArn: Option[Arn] = None,
    infrastructureConfigurationArn: Option[Arn] = None,
    distributionConfigurationArn: Option[Arn] = None,
    imageTestsConfiguration: Option[
      zio.aws.imagebuilder.model.ImageTestsConfiguration
    ] = None,
    schedule: Option[zio.aws.imagebuilder.model.Schedule] = None,
    status: Option[zio.aws.imagebuilder.model.PipelineStatus] = None,
    dateCreated: Option[DateTime] = None,
    dateUpdated: Option[DateTime] = None,
    dateLastRun: Option[DateTime] = None,
    dateNextRun: Option[DateTime] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImagePipeline = {
    import ImagePipeline.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImagePipeline
      .builder()
      .optionallyWith(
        arn.map(value => ImageBuilderArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        enhancedImageMetadataEnabled.map(value => value: java.lang.Boolean)
      )(_.enhancedImageMetadataEnabled)
      .optionallyWith(
        imageRecipeArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.imageRecipeArn)
      .optionallyWith(
        containerRecipeArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.containerRecipeArn)
      .optionallyWith(
        infrastructureConfigurationArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.infrastructureConfigurationArn)
      .optionallyWith(
        distributionConfigurationArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.distributionConfigurationArn)
      .optionallyWith(
        imageTestsConfiguration.map(value => value.buildAwsValue())
      )(_.imageTestsConfiguration)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(
        dateUpdated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateUpdated)
      .optionallyWith(
        dateLastRun.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateLastRun)
      .optionallyWith(
        dateNextRun.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateNextRun)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ImagePipeline.ReadOnly =
    zio.aws.imagebuilder.model.ImagePipeline.wrap(buildAwsValue())
}
object ImagePipeline {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImagePipeline
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImagePipeline =
      zio.aws.imagebuilder.model.ImagePipeline(
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        platform.map(value => value),
        enhancedImageMetadataEnabled.map(value => value),
        imageRecipeArn.map(value => value),
        containerRecipeArn.map(value => value),
        infrastructureConfigurationArn.map(value => value),
        distributionConfigurationArn.map(value => value),
        imageTestsConfiguration.map(value => value.asEditable),
        schedule.map(value => value.asEditable),
        status.map(value => value),
        dateCreated.map(value => value),
        dateUpdated.map(value => value),
        dateLastRun.map(value => value),
        dateNextRun.map(value => value),
        tags.map(value => value)
      )
    def arn: Option[ImageBuilderArn]
    def name: Option[ResourceName]
    def description: Option[NonEmptyString]
    def platform: Option[zio.aws.imagebuilder.model.Platform]
    def enhancedImageMetadataEnabled: Option[NullableBoolean]
    def imageRecipeArn: Option[Arn]
    def containerRecipeArn: Option[Arn]
    def infrastructureConfigurationArn: Option[Arn]
    def distributionConfigurationArn: Option[Arn]
    def imageTestsConfiguration
        : Option[zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly]
    def schedule: Option[zio.aws.imagebuilder.model.Schedule.ReadOnly]
    def status: Option[zio.aws.imagebuilder.model.PipelineStatus]
    def dateCreated: Option[DateTime]
    def dateUpdated: Option[DateTime]
    def dateLastRun: Option[DateTime]
    def dateNextRun: Option[DateTime]
    def tags: Option[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getPlatform: ZIO[Any, AwsError, zio.aws.imagebuilder.model.Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getEnhancedImageMetadataEnabled: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField(
        "enhancedImageMetadataEnabled",
        enhancedImageMetadataEnabled
      )
    def getImageRecipeArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("imageRecipeArn", imageRecipeArn)
    def getContainerRecipeArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("containerRecipeArn", containerRecipeArn)
    def getInfrastructureConfigurationArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField(
        "infrastructureConfigurationArn",
        infrastructureConfigurationArn
      )
    def getDistributionConfigurationArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField(
        "distributionConfigurationArn",
        distributionConfigurationArn
      )
    def getImageTestsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "imageTestsConfiguration",
      imageTestsConfiguration
    )
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.Schedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.PipelineStatus] =
      AwsError.unwrapOptionField("status", status)
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getDateUpdated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateUpdated", dateUpdated)
    def getDateLastRun: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateLastRun", dateLastRun)
    def getDateNextRun: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateNextRun", dateNextRun)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImagePipeline
  ) extends zio.aws.imagebuilder.model.ImagePipeline.ReadOnly {
    override val arn: Option[ImageBuilderArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val platform: Option[zio.aws.imagebuilder.model.Platform] = scala
      .Option(impl.platform())
      .map(value => zio.aws.imagebuilder.model.Platform.wrap(value))
    override val enhancedImageMetadataEnabled: Option[NullableBoolean] = scala
      .Option(impl.enhancedImageMetadataEnabled())
      .map(value => value: NullableBoolean)
    override val imageRecipeArn: Option[Arn] = scala
      .Option(impl.imageRecipeArn())
      .map(value => zio.aws.imagebuilder.model.primitives.Arn(value))
    override val containerRecipeArn: Option[Arn] = scala
      .Option(impl.containerRecipeArn())
      .map(value => zio.aws.imagebuilder.model.primitives.Arn(value))
    override val infrastructureConfigurationArn: Option[Arn] = scala
      .Option(impl.infrastructureConfigurationArn())
      .map(value => zio.aws.imagebuilder.model.primitives.Arn(value))
    override val distributionConfigurationArn: Option[Arn] = scala
      .Option(impl.distributionConfigurationArn())
      .map(value => zio.aws.imagebuilder.model.primitives.Arn(value))
    override val imageTestsConfiguration
        : Option[zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly] =
      scala
        .Option(impl.imageTestsConfiguration())
        .map(value =>
          zio.aws.imagebuilder.model.ImageTestsConfiguration.wrap(value)
        )
    override val schedule
        : Option[zio.aws.imagebuilder.model.Schedule.ReadOnly] = scala
      .Option(impl.schedule())
      .map(value => zio.aws.imagebuilder.model.Schedule.wrap(value))
    override val status: Option[zio.aws.imagebuilder.model.PipelineStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.imagebuilder.model.PipelineStatus.wrap(value))
    override val dateCreated: Option[DateTime] = scala
      .Option(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val dateUpdated: Option[DateTime] = scala
      .Option(impl.dateUpdated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val dateLastRun: Option[DateTime] = scala
      .Option(impl.dateLastRun())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val dateNextRun: Option[DateTime] = scala
      .Option(impl.dateNextRun())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImagePipeline
  ): zio.aws.imagebuilder.model.ImagePipeline.ReadOnly = new Wrapper(impl)
}
