package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  DistributionConfigurationArn,
  ClientToken,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateDistributionConfigurationResponse(
    requestId: Option[NonEmptyString] = None,
    clientToken: Option[ClientToken] = None,
    distributionConfigurationArn: Option[DistributionConfigurationArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationResponse = {
    import UpdateDistributionConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        distributionConfigurationArn.map(value =>
          DistributionConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.distributionConfigurationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.UpdateDistributionConfigurationResponse.ReadOnly =
    zio.aws.imagebuilder.model.UpdateDistributionConfigurationResponse
      .wrap(buildAwsValue())
}
object UpdateDistributionConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.UpdateDistributionConfigurationResponse =
      zio.aws.imagebuilder.model.UpdateDistributionConfigurationResponse(
        requestId.map(value => value),
        clientToken.map(value => value),
        distributionConfigurationArn.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def clientToken: Option[ClientToken]
    def distributionConfigurationArn: Option[DistributionConfigurationArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDistributionConfigurationArn
        : ZIO[Any, AwsError, DistributionConfigurationArn] =
      AwsError.unwrapOptionField(
        "distributionConfigurationArn",
        distributionConfigurationArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationResponse
  ) extends zio.aws.imagebuilder.model.UpdateDistributionConfigurationResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.imagebuilder.model.primitives.ClientToken(value))
    override val distributionConfigurationArn
        : Option[DistributionConfigurationArn] = scala
      .Option(impl.distributionConfigurationArn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives
          .DistributionConfigurationArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationResponse
  ): zio.aws.imagebuilder.model.UpdateDistributionConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
