package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ResourcePolicyDocument,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetContainerRecipePolicyResponse(
    requestId: Option[NonEmptyString] = None,
    policy: Option[ResourcePolicyDocument] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipePolicyResponse = {
    import GetContainerRecipePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipePolicyResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        policy.map(value =>
          ResourcePolicyDocument.unwrap(value): java.lang.String
        )
      )(_.policy)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.GetContainerRecipePolicyResponse.ReadOnly =
    zio.aws.imagebuilder.model.GetContainerRecipePolicyResponse
      .wrap(buildAwsValue())
}
object GetContainerRecipePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.GetContainerRecipePolicyResponse =
      zio.aws.imagebuilder.model.GetContainerRecipePolicyResponse(
        requestId.map(value => value),
        policy.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def policy: Option[ResourcePolicyDocument]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getPolicy: ZIO[Any, AwsError, ResourcePolicyDocument] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipePolicyResponse
  ) extends zio.aws.imagebuilder.model.GetContainerRecipePolicyResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val policy: Option[ResourcePolicyDocument] = scala
      .Option(impl.policy())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ResourcePolicyDocument(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipePolicyResponse
  ): zio.aws.imagebuilder.model.GetContainerRecipePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
