package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  TagValue,
  Uri,
  InlineDockerFileTemplate,
  VersionNumber,
  ClientToken,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateContainerRecipeRequest(
    containerType: zio.aws.imagebuilder.model.ContainerType,
    name: ResourceName,
    description: Option[NonEmptyString] = None,
    semanticVersion: VersionNumber,
    components: Iterable[zio.aws.imagebuilder.model.ComponentConfiguration],
    instanceConfiguration: Option[
      zio.aws.imagebuilder.model.InstanceConfiguration
    ] = None,
    dockerfileTemplateData: Option[InlineDockerFileTemplate] = None,
    dockerfileTemplateUri: Option[Uri] = None,
    platformOverride: Option[zio.aws.imagebuilder.model.Platform] = None,
    imageOsVersionOverride: Option[NonEmptyString] = None,
    parentImage: NonEmptyString,
    tags: Option[Map[TagKey, TagValue]] = None,
    workingDirectory: Option[NonEmptyString] = None,
    targetRepository: zio.aws.imagebuilder.model.TargetContainerRepository,
    kmsKeyId: Option[NonEmptyString] = None,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeRequest = {
    import CreateContainerRecipeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeRequest
      .builder()
      .containerType(containerType.unwrap)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .semanticVersion(VersionNumber.unwrap(semanticVersion): java.lang.String)
      .components(components.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        instanceConfiguration.map(value => value.buildAwsValue())
      )(_.instanceConfiguration)
      .optionallyWith(
        dockerfileTemplateData.map(value =>
          InlineDockerFileTemplate.unwrap(value): java.lang.String
        )
      )(_.dockerfileTemplateData)
      .optionallyWith(
        dockerfileTemplateUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.dockerfileTemplateUri)
      .optionallyWith(platformOverride.map(value => value.unwrap))(
        _.platformOverride
      )
      .optionallyWith(
        imageOsVersionOverride.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.imageOsVersionOverride)
      .parentImage(NonEmptyString.unwrap(parentImage): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        workingDirectory.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.workingDirectory)
      .targetRepository(targetRepository.buildAwsValue())
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.CreateContainerRecipeRequest.ReadOnly =
    zio.aws.imagebuilder.model.CreateContainerRecipeRequest
      .wrap(buildAwsValue())
}
object CreateContainerRecipeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CreateContainerRecipeRequest =
      zio.aws.imagebuilder.model.CreateContainerRecipeRequest(
        containerType,
        name,
        description.map(value => value),
        semanticVersion,
        components.map { item =>
          item.asEditable
        },
        instanceConfiguration.map(value => value.asEditable),
        dockerfileTemplateData.map(value => value),
        dockerfileTemplateUri.map(value => value),
        platformOverride.map(value => value),
        imageOsVersionOverride.map(value => value),
        parentImage,
        tags.map(value => value),
        workingDirectory.map(value => value),
        targetRepository.asEditable,
        kmsKeyId.map(value => value),
        clientToken
      )
    def containerType: zio.aws.imagebuilder.model.ContainerType
    def name: ResourceName
    def description: Option[NonEmptyString]
    def semanticVersion: VersionNumber
    def components
        : List[zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly]
    def instanceConfiguration
        : Option[zio.aws.imagebuilder.model.InstanceConfiguration.ReadOnly]
    def dockerfileTemplateData: Option[InlineDockerFileTemplate]
    def dockerfileTemplateUri: Option[Uri]
    def platformOverride: Option[zio.aws.imagebuilder.model.Platform]
    def imageOsVersionOverride: Option[NonEmptyString]
    def parentImage: NonEmptyString
    def tags: Option[Map[TagKey, TagValue]]
    def workingDirectory: Option[NonEmptyString]
    def targetRepository
        : zio.aws.imagebuilder.model.TargetContainerRepository.ReadOnly
    def kmsKeyId: Option[NonEmptyString]
    def clientToken: ClientToken
    def getContainerType
        : ZIO[Any, Nothing, zio.aws.imagebuilder.model.ContainerType] =
      ZIO.succeed(containerType)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getSemanticVersion: ZIO[Any, Nothing, VersionNumber] =
      ZIO.succeed(semanticVersion)
    def getComponents: ZIO[Any, Nothing, List[
      zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly
    ]] = ZIO.succeed(components)
    def getInstanceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.InstanceConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("instanceConfiguration", instanceConfiguration)
    def getDockerfileTemplateData
        : ZIO[Any, AwsError, InlineDockerFileTemplate] = AwsError
      .unwrapOptionField("dockerfileTemplateData", dockerfileTemplateData)
    def getDockerfileTemplateUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("dockerfileTemplateUri", dockerfileTemplateUri)
    def getPlatformOverride
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.Platform] =
      AwsError.unwrapOptionField("platformOverride", platformOverride)
    def getImageOsVersionOverride: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("imageOsVersionOverride", imageOsVersionOverride)
    def getParentImage: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(parentImage)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorkingDirectory: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("workingDirectory", workingDirectory)
    def getTargetRepository: ZIO[
      Any,
      Nothing,
      zio.aws.imagebuilder.model.TargetContainerRepository.ReadOnly
    ] = ZIO.succeed(targetRepository)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeRequest
  ) extends zio.aws.imagebuilder.model.CreateContainerRecipeRequest.ReadOnly {
    override val containerType: zio.aws.imagebuilder.model.ContainerType =
      zio.aws.imagebuilder.model.ContainerType.wrap(impl.containerType())
    override val name: ResourceName =
      zio.aws.imagebuilder.model.primitives.ResourceName(impl.name())
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val semanticVersion: VersionNumber =
      zio.aws.imagebuilder.model.primitives
        .VersionNumber(impl.semanticVersion())
    override val components
        : List[zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly] =
      impl
        .components()
        .asScala
        .map { item =>
          zio.aws.imagebuilder.model.ComponentConfiguration.wrap(item)
        }
        .toList
    override val instanceConfiguration
        : Option[zio.aws.imagebuilder.model.InstanceConfiguration.ReadOnly] =
      scala
        .Option(impl.instanceConfiguration())
        .map(value =>
          zio.aws.imagebuilder.model.InstanceConfiguration.wrap(value)
        )
    override val dockerfileTemplateData: Option[InlineDockerFileTemplate] =
      scala
        .Option(impl.dockerfileTemplateData())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.InlineDockerFileTemplate(value)
        )
    override val dockerfileTemplateUri: Option[Uri] = scala
      .Option(impl.dockerfileTemplateUri())
      .map(value => zio.aws.imagebuilder.model.primitives.Uri(value))
    override val platformOverride: Option[zio.aws.imagebuilder.model.Platform] =
      scala
        .Option(impl.platformOverride())
        .map(value => zio.aws.imagebuilder.model.Platform.wrap(value))
    override val imageOsVersionOverride: Option[NonEmptyString] = scala
      .Option(impl.imageOsVersionOverride())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val parentImage: NonEmptyString =
      zio.aws.imagebuilder.model.primitives.NonEmptyString(impl.parentImage())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val workingDirectory: Option[NonEmptyString] = scala
      .Option(impl.workingDirectory())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val targetRepository
        : zio.aws.imagebuilder.model.TargetContainerRepository.ReadOnly =
      zio.aws.imagebuilder.model.TargetContainerRepository
        .wrap(impl.targetRepository())
    override val kmsKeyId: Option[NonEmptyString] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeRequest
  ): zio.aws.imagebuilder.model.CreateContainerRecipeRequest.ReadOnly =
    new Wrapper(impl)
}
