package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class S3Logs(
    s3BucketName: Option[NonEmptyString] = None,
    s3KeyPrefix: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.S3Logs = {
    import S3Logs.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.S3Logs
      .builder()
      .optionallyWith(
        s3BucketName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.s3BucketName)
      .optionallyWith(
        s3KeyPrefix.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.s3KeyPrefix)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.S3Logs.ReadOnly =
    zio.aws.imagebuilder.model.S3Logs.wrap(buildAwsValue())
}
object S3Logs {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.S3Logs
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.S3Logs =
      zio.aws.imagebuilder.model.S3Logs(
        s3BucketName.map(value => value),
        s3KeyPrefix.map(value => value)
      )
    def s3BucketName: Option[NonEmptyString]
    def s3KeyPrefix: Option[NonEmptyString]
    def getS3BucketName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getS3KeyPrefix: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.S3Logs
  ) extends zio.aws.imagebuilder.model.S3Logs.ReadOnly {
    override val s3BucketName: Option[NonEmptyString] = scala
      .Option(impl.s3BucketName())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val s3KeyPrefix: Option[NonEmptyString] = scala
      .Option(impl.s3KeyPrefix())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.S3Logs
  ): zio.aws.imagebuilder.model.S3Logs.ReadOnly = new Wrapper(impl)
}
