package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{PaginationToken, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListImagePipelinesResponse(
    requestId: Option[NonEmptyString] = None,
    imagePipelineList: Option[
      Iterable[zio.aws.imagebuilder.model.ImagePipeline]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse = {
    import ListImagePipelinesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        imagePipelineList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.imagePipelineList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListImagePipelinesResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListImagePipelinesResponse.wrap(buildAwsValue())
}
object ListImagePipelinesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListImagePipelinesResponse =
      zio.aws.imagebuilder.model.ListImagePipelinesResponse(
        requestId.map(value => value),
        imagePipelineList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def imagePipelineList
        : Option[List[zio.aws.imagebuilder.model.ImagePipeline.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getImagePipelineList: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.ImagePipeline.ReadOnly
    ]] = AwsError.unwrapOptionField("imagePipelineList", imagePipelineList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse
  ) extends zio.aws.imagebuilder.model.ListImagePipelinesResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imagePipelineList
        : Option[List[zio.aws.imagebuilder.model.ImagePipeline.ReadOnly]] =
      scala
        .Option(impl.imagePipelineList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.ImagePipeline.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse
  ): zio.aws.imagebuilder.model.ListImagePipelinesResponse.ReadOnly =
    new Wrapper(impl)
}
