package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{PaginationToken, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListImagePackagesResponse(
    requestId: Option[NonEmptyString] = None,
    imagePackageList: Option[
      Iterable[zio.aws.imagebuilder.model.ImagePackage]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesResponse = {
    import ListImagePackagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        imagePackageList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.imagePackageList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListImagePackagesResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListImagePackagesResponse.wrap(buildAwsValue())
}
object ListImagePackagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListImagePackagesResponse =
      zio.aws.imagebuilder.model.ListImagePackagesResponse(
        requestId.map(value => value),
        imagePackageList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def imagePackageList
        : Option[List[zio.aws.imagebuilder.model.ImagePackage.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getImagePackageList: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.ImagePackage.ReadOnly
    ]] = AwsError.unwrapOptionField("imagePackageList", imagePackageList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesResponse
  ) extends zio.aws.imagebuilder.model.ListImagePackagesResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imagePackageList
        : Option[List[zio.aws.imagebuilder.model.ImagePackage.ReadOnly]] = scala
      .Option(impl.imagePackageList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.ImagePackage.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesResponse
  ): zio.aws.imagebuilder.model.ListImagePackagesResponse.ReadOnly =
    new Wrapper(impl)
}
