package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  TagValue,
  VersionNumber,
  ClientToken,
  OsVersion,
  NonEmptyString,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportVmImageRequest(
    name: NonEmptyString,
    semanticVersion: VersionNumber,
    description: Option[NonEmptyString] = None,
    platform: zio.aws.imagebuilder.model.Platform,
    osVersion: Option[OsVersion] = None,
    vmImportTaskId: NonEmptyString,
    tags: Option[Map[TagKey, TagValue]] = None,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImportVmImageRequest = {
    import ImportVmImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImportVmImageRequest
      .builder()
      .name(NonEmptyString.unwrap(name): java.lang.String)
      .semanticVersion(VersionNumber.unwrap(semanticVersion): java.lang.String)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .platform(platform.unwrap)
      .optionallyWith(
        osVersion.map(value => OsVersion.unwrap(value): java.lang.String)
      )(_.osVersion)
      .vmImportTaskId(NonEmptyString.unwrap(vmImportTaskId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ImportVmImageRequest.ReadOnly =
    zio.aws.imagebuilder.model.ImportVmImageRequest.wrap(buildAwsValue())
}
object ImportVmImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImportVmImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImportVmImageRequest =
      zio.aws.imagebuilder.model.ImportVmImageRequest(
        name,
        semanticVersion,
        description.map(value => value),
        platform,
        osVersion.map(value => value),
        vmImportTaskId,
        tags.map(value => value),
        clientToken
      )
    def name: NonEmptyString
    def semanticVersion: VersionNumber
    def description: Option[NonEmptyString]
    def platform: zio.aws.imagebuilder.model.Platform
    def osVersion: Option[OsVersion]
    def vmImportTaskId: NonEmptyString
    def tags: Option[Map[TagKey, TagValue]]
    def clientToken: ClientToken
    def getName: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(name)
    def getSemanticVersion: ZIO[Any, Nothing, VersionNumber] =
      ZIO.succeed(semanticVersion)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getPlatform: ZIO[Any, Nothing, zio.aws.imagebuilder.model.Platform] =
      ZIO.succeed(platform)
    def getOsVersion: ZIO[Any, AwsError, OsVersion] =
      AwsError.unwrapOptionField("osVersion", osVersion)
    def getVmImportTaskId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(vmImportTaskId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImportVmImageRequest
  ) extends zio.aws.imagebuilder.model.ImportVmImageRequest.ReadOnly {
    override val name: NonEmptyString =
      zio.aws.imagebuilder.model.primitives.NonEmptyString(impl.name())
    override val semanticVersion: VersionNumber =
      zio.aws.imagebuilder.model.primitives
        .VersionNumber(impl.semanticVersion())
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val platform: zio.aws.imagebuilder.model.Platform =
      zio.aws.imagebuilder.model.Platform.wrap(impl.platform())
    override val osVersion: Option[OsVersion] = scala
      .Option(impl.osVersion())
      .map(value => zio.aws.imagebuilder.model.primitives.OsVersion(value))
    override val vmImportTaskId: NonEmptyString =
      zio.aws.imagebuilder.model.primitives
        .NonEmptyString(impl.vmImportTaskId())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImportVmImageRequest
  ): zio.aws.imagebuilder.model.ImportVmImageRequest.ReadOnly = new Wrapper(
    impl
  )
}
