package zio.aws.imagebuilder
import zio.prelude.Subtype
import zio.aws.imagebuilder.model.primitives.{
  OrganizationArn,
  AccountId,
  TagValue,
  InstanceType,
  ComponentParameterValue,
  OrganizationalUnitArn,
  OsVersion,
  FilterValue,
  NonEmptyString,
  LicenseConfigurationArn,
  TagKey
}
import zio.aws.imagebuilder.model.primitives.ComponentVersionArnOrBuildVersionArn.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.imagebuilder.model.primitives.AccountId.Type
    object AmiNameString extends Subtype[String]
    type AmiNameString =
      zio.aws.imagebuilder.model.primitives.AmiNameString.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.imagebuilder.model.primitives.Arn.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.imagebuilder.model.primitives.ClientToken.Type
    object ComponentBuildVersionArn extends Subtype[String]
    type ComponentBuildVersionArn =
      zio.aws.imagebuilder.model.primitives.ComponentBuildVersionArn.Type
    object ComponentData extends Subtype[String]
    type ComponentData =
      zio.aws.imagebuilder.model.primitives.ComponentData.Type
    object ComponentParameterDescription extends Subtype[String]
    type ComponentParameterDescription =
      zio.aws.imagebuilder.model.primitives.ComponentParameterDescription.Type
    object ComponentParameterName extends Subtype[String]
    type ComponentParameterName =
      zio.aws.imagebuilder.model.primitives.ComponentParameterName.Type
    object ComponentParameterType extends Subtype[String]
    type ComponentParameterType =
      zio.aws.imagebuilder.model.primitives.ComponentParameterType.Type
    object ComponentParameterValue extends Subtype[String]
    type ComponentParameterValue =
      zio.aws.imagebuilder.model.primitives.ComponentParameterValue.Type
    object ComponentVersionArn extends Subtype[String]
    type ComponentVersionArn =
      zio.aws.imagebuilder.model.primitives.ComponentVersionArn.Type
    object ComponentVersionArnOrBuildVersionArn extends Subtype[String]
    type ComponentVersionArnOrBuildVersionArn =
      zio.aws.imagebuilder.model.primitives.ComponentVersionArnOrBuildVersionArn.Type
    object ContainerRecipeArn extends Subtype[String]
    type ContainerRecipeArn =
      zio.aws.imagebuilder.model.primitives.ContainerRecipeArn.Type
    object DateTime extends Subtype[String]
    type DateTime = zio.aws.imagebuilder.model.primitives.DateTime.Type
    object DistributionConfigurationArn extends Subtype[String]
    type DistributionConfigurationArn =
      zio.aws.imagebuilder.model.primitives.DistributionConfigurationArn.Type
    object DistributionTimeoutMinutes extends Subtype[Int]
    type DistributionTimeoutMinutes =
      zio.aws.imagebuilder.model.primitives.DistributionTimeoutMinutes.Type
    object DockerFileTemplate extends Subtype[String]
    type DockerFileTemplate =
      zio.aws.imagebuilder.model.primitives.DockerFileTemplate.Type
    object EbsIopsInteger extends Subtype[Int]
    type EbsIopsInteger =
      zio.aws.imagebuilder.model.primitives.EbsIopsInteger.Type
    object EbsVolumeSizeInteger extends Subtype[Int]
    type EbsVolumeSizeInteger =
      zio.aws.imagebuilder.model.primitives.EbsVolumeSizeInteger.Type
    object EbsVolumeThroughput extends Subtype[Int]
    type EbsVolumeThroughput =
      zio.aws.imagebuilder.model.primitives.EbsVolumeThroughput.Type
    object EmptyString extends Subtype[String]
    type EmptyString = zio.aws.imagebuilder.model.primitives.EmptyString.Type
    object FilterName extends Subtype[String]
    type FilterName = zio.aws.imagebuilder.model.primitives.FilterName.Type
    object FilterValue extends Subtype[String]
    type FilterValue = zio.aws.imagebuilder.model.primitives.FilterValue.Type
    object HttpPutResponseHopLimit extends Subtype[Int]
    type HttpPutResponseHopLimit =
      zio.aws.imagebuilder.model.primitives.HttpPutResponseHopLimit.Type
    object HttpTokens extends Subtype[String]
    type HttpTokens = zio.aws.imagebuilder.model.primitives.HttpTokens.Type
    object ImageBuildVersionArn extends Subtype[String]
    type ImageBuildVersionArn =
      zio.aws.imagebuilder.model.primitives.ImageBuildVersionArn.Type
    object ImageBuilderArn extends Subtype[String]
    type ImageBuilderArn =
      zio.aws.imagebuilder.model.primitives.ImageBuilderArn.Type
    object ImagePipelineArn extends Subtype[String]
    type ImagePipelineArn =
      zio.aws.imagebuilder.model.primitives.ImagePipelineArn.Type
    object ImageRecipeArn extends Subtype[String]
    type ImageRecipeArn =
      zio.aws.imagebuilder.model.primitives.ImageRecipeArn.Type
    object ImageTestsTimeoutMinutes extends Subtype[Int]
    type ImageTestsTimeoutMinutes =
      zio.aws.imagebuilder.model.primitives.ImageTestsTimeoutMinutes.Type
    object ImageVersionArn extends Subtype[String]
    type ImageVersionArn =
      zio.aws.imagebuilder.model.primitives.ImageVersionArn.Type
    object ImageVersionArnOrBuildVersionArn extends Subtype[String]
    type ImageVersionArnOrBuildVersionArn =
      zio.aws.imagebuilder.model.primitives.ImageVersionArnOrBuildVersionArn.Type
    object InfrastructureConfigurationArn extends Subtype[String]
    type InfrastructureConfigurationArn =
      zio.aws.imagebuilder.model.primitives.InfrastructureConfigurationArn.Type
    object InlineComponentData extends Subtype[String]
    type InlineComponentData =
      zio.aws.imagebuilder.model.primitives.InlineComponentData.Type
    object InlineDockerFileTemplate extends Subtype[String]
    type InlineDockerFileTemplate =
      zio.aws.imagebuilder.model.primitives.InlineDockerFileTemplate.Type
    object InstanceProfileNameType extends Subtype[String]
    type InstanceProfileNameType =
      zio.aws.imagebuilder.model.primitives.InstanceProfileNameType.Type
    object InstanceType extends Subtype[String]
    type InstanceType = zio.aws.imagebuilder.model.primitives.InstanceType.Type
    object LaunchTemplateId extends Subtype[String]
    type LaunchTemplateId =
      zio.aws.imagebuilder.model.primitives.LaunchTemplateId.Type
    object LicenseConfigurationArn extends Subtype[String]
    type LicenseConfigurationArn =
      zio.aws.imagebuilder.model.primitives.LicenseConfigurationArn.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString =
      zio.aws.imagebuilder.model.primitives.NonEmptyString.Type
    object NullableBoolean extends Subtype[Boolean]
    type NullableBoolean =
      zio.aws.imagebuilder.model.primitives.NullableBoolean.Type
    object OrganizationArn extends Subtype[String]
    type OrganizationArn =
      zio.aws.imagebuilder.model.primitives.OrganizationArn.Type
    object OrganizationalUnitArn extends Subtype[String]
    type OrganizationalUnitArn =
      zio.aws.imagebuilder.model.primitives.OrganizationalUnitArn.Type
    object OsVersion extends Subtype[String]
    type OsVersion = zio.aws.imagebuilder.model.primitives.OsVersion.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.imagebuilder.model.primitives.PaginationToken.Type
    object ResourceName extends Subtype[String]
    type ResourceName = zio.aws.imagebuilder.model.primitives.ResourceName.Type
    object ResourcePolicyDocument extends Subtype[String]
    type ResourcePolicyDocument =
      zio.aws.imagebuilder.model.primitives.ResourcePolicyDocument.Type
    object RestrictedInteger extends Subtype[Int]
    type RestrictedInteger =
      zio.aws.imagebuilder.model.primitives.RestrictedInteger.Type
    object SnsTopicArn extends Subtype[String]
    type SnsTopicArn = zio.aws.imagebuilder.model.primitives.SnsTopicArn.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.imagebuilder.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.imagebuilder.model.primitives.TagValue.Type
    object Timezone extends Subtype[String]
    type Timezone = zio.aws.imagebuilder.model.primitives.Timezone.Type
    object Uri extends Subtype[String]
    type Uri = zio.aws.imagebuilder.model.primitives.Uri.Type
    object UserDataOverride extends Subtype[String]
    type UserDataOverride =
      zio.aws.imagebuilder.model.primitives.UserDataOverride.Type
    object VersionNumber extends Subtype[String]
    type VersionNumber =
      zio.aws.imagebuilder.model.primitives.VersionNumber.Type
  }
  type AccountList = List[AccountId]
  type AmiList = List[zio.aws.imagebuilder.model.Ami]
  type ComponentConfigurationList =
    List[zio.aws.imagebuilder.model.ComponentConfiguration]
  type ComponentParameterDetailList =
    List[zio.aws.imagebuilder.model.ComponentParameterDetail]
  type ComponentParameterList =
    List[zio.aws.imagebuilder.model.ComponentParameter]
  type ComponentParameterValueList = List[ComponentParameterValue]
  type ComponentSummaryList = List[zio.aws.imagebuilder.model.ComponentSummary]
  type ComponentVersionList = List[zio.aws.imagebuilder.model.ComponentVersion]
  type ContainerList = List[zio.aws.imagebuilder.model.Container]
  type ContainerRecipeSummaryList =
    List[zio.aws.imagebuilder.model.ContainerRecipeSummary]
  type DistributionConfigurationSummaryList =
    List[zio.aws.imagebuilder.model.DistributionConfigurationSummary]
  type DistributionList = List[zio.aws.imagebuilder.model.Distribution]
  type FilterList = List[zio.aws.imagebuilder.model.Filter]
  type FilterValues = List[FilterValue]
  type ImagePackageList = List[zio.aws.imagebuilder.model.ImagePackage]
  type ImagePipelineList = List[zio.aws.imagebuilder.model.ImagePipeline]
  type ImageRecipeSummaryList =
    List[zio.aws.imagebuilder.model.ImageRecipeSummary]
  type ImageSummaryList = List[zio.aws.imagebuilder.model.ImageSummary]
  type ImageVersionList = List[zio.aws.imagebuilder.model.ImageVersion]
  type InfrastructureConfigurationSummaryList =
    List[zio.aws.imagebuilder.model.InfrastructureConfigurationSummary]
  type InstanceBlockDeviceMappings =
    List[zio.aws.imagebuilder.model.InstanceBlockDeviceMapping]
  type InstanceTypeList = List[InstanceType]
  type LaunchTemplateConfigurationList =
    List[zio.aws.imagebuilder.model.LaunchTemplateConfiguration]
  type LicenseConfigurationArnList = List[LicenseConfigurationArn]
  type OrganizationArnList = List[OrganizationArn]
  type OrganizationalUnitArnList = List[OrganizationalUnitArn]
  type OsVersionList = List[OsVersion]
  type RegionList = List[NonEmptyString]
  type ResourceTagMap = Map[TagKey, TagValue]
  type SecurityGroupIds = List[NonEmptyString]
  type StringList = List[NonEmptyString]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
}
