package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{PaginationToken, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListImageRecipesResponse(
    requestId: Option[NonEmptyString] = None,
    imageRecipeSummaryList: Option[
      Iterable[zio.aws.imagebuilder.model.ImageRecipeSummary]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse = {
    import ListImageRecipesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        imageRecipeSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.imageRecipeSummaryList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ListImageRecipesResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListImageRecipesResponse.wrap(buildAwsValue())
}
object ListImageRecipesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListImageRecipesResponse =
      zio.aws.imagebuilder.model.ListImageRecipesResponse(
        requestId.map(value => value),
        imageRecipeSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def imageRecipeSummaryList
        : Option[List[zio.aws.imagebuilder.model.ImageRecipeSummary.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getImageRecipeSummaryList: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.ImageRecipeSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "imageRecipeSummaryList",
      imageRecipeSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse
  ) extends zio.aws.imagebuilder.model.ListImageRecipesResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imageRecipeSummaryList
        : Option[List[zio.aws.imagebuilder.model.ImageRecipeSummary.ReadOnly]] =
      scala
        .Option(impl.imageRecipeSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.ImageRecipeSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse
  ): zio.aws.imagebuilder.model.ListImageRecipesResponse.ReadOnly = new Wrapper(
    impl
  )
}
