package zio.aws.imagebuilder.model
import java.lang.Integer
import zio.aws.imagebuilder.model.primitives.{
  PaginationToken,
  RestrictedInteger,
  ComponentVersionArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListComponentBuildVersionsRequest(
    componentVersionArn: ComponentVersionArn,
    maxResults: Option[RestrictedInteger] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest = {
    import ListComponentBuildVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest
      .builder()
      .componentVersionArn(
        ComponentVersionArn.unwrap(componentVersionArn): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => RestrictedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListComponentBuildVersionsRequest.ReadOnly =
    zio.aws.imagebuilder.model.ListComponentBuildVersionsRequest
      .wrap(buildAwsValue())
}
object ListComponentBuildVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.ListComponentBuildVersionsRequest =
      zio.aws.imagebuilder.model.ListComponentBuildVersionsRequest(
        componentVersionArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def componentVersionArn: ComponentVersionArn
    def maxResults: Option[RestrictedInteger]
    def nextToken: Option[PaginationToken]
    def getComponentVersionArn: ZIO[Any, Nothing, ComponentVersionArn] =
      ZIO.succeed(componentVersionArn)
    def getMaxResults: ZIO[Any, AwsError, RestrictedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest
  ) extends zio.aws.imagebuilder.model.ListComponentBuildVersionsRequest.ReadOnly {
    override val componentVersionArn: ComponentVersionArn =
      zio.aws.imagebuilder.model.primitives
        .ComponentVersionArn(impl.componentVersionArn())
    override val maxResults: Option[RestrictedInteger] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.RestrictedInteger(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest
  ): zio.aws.imagebuilder.model.ListComponentBuildVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
