package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImageBuilderArn,
  TagValue,
  Arn,
  DateTime,
  VersionNumber,
  OsVersion,
  NullableBoolean,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Image(
    arn: Option[ImageBuilderArn] = None,
    `type`: Option[zio.aws.imagebuilder.model.ImageType] = None,
    name: Option[ResourceName] = None,
    version: Option[VersionNumber] = None,
    platform: Option[zio.aws.imagebuilder.model.Platform] = None,
    enhancedImageMetadataEnabled: Option[NullableBoolean] = None,
    osVersion: Option[OsVersion] = None,
    state: Option[zio.aws.imagebuilder.model.ImageState] = None,
    imageRecipe: Option[zio.aws.imagebuilder.model.ImageRecipe] = None,
    containerRecipe: Option[zio.aws.imagebuilder.model.ContainerRecipe] = None,
    sourcePipelineName: Option[ResourceName] = None,
    sourcePipelineArn: Option[Arn] = None,
    infrastructureConfiguration: Option[
      zio.aws.imagebuilder.model.InfrastructureConfiguration
    ] = None,
    distributionConfiguration: Option[
      zio.aws.imagebuilder.model.DistributionConfiguration
    ] = None,
    imageTestsConfiguration: Option[
      zio.aws.imagebuilder.model.ImageTestsConfiguration
    ] = None,
    dateCreated: Option[DateTime] = None,
    outputResources: Option[zio.aws.imagebuilder.model.OutputResources] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    buildType: Option[zio.aws.imagebuilder.model.BuildType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.Image = {
    import Image.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.Image
      .builder()
      .optionallyWith(
        arn.map(value => ImageBuilderArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value => VersionNumber.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        enhancedImageMetadataEnabled.map(value =>
          NullableBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.enhancedImageMetadataEnabled)
      .optionallyWith(
        osVersion.map(value => OsVersion.unwrap(value): java.lang.String)
      )(_.osVersion)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(imageRecipe.map(value => value.buildAwsValue()))(
        _.imageRecipe
      )
      .optionallyWith(containerRecipe.map(value => value.buildAwsValue()))(
        _.containerRecipe
      )
      .optionallyWith(
        sourcePipelineName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.sourcePipelineName)
      .optionallyWith(
        sourcePipelineArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.sourcePipelineArn)
      .optionallyWith(
        infrastructureConfiguration.map(value => value.buildAwsValue())
      )(_.infrastructureConfiguration)
      .optionallyWith(
        distributionConfiguration.map(value => value.buildAwsValue())
      )(_.distributionConfiguration)
      .optionallyWith(
        imageTestsConfiguration.map(value => value.buildAwsValue())
      )(_.imageTestsConfiguration)
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(outputResources.map(value => value.buildAwsValue()))(
        _.outputResources
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(buildType.map(value => value.unwrap))(_.buildType)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.Image.ReadOnly =
    zio.aws.imagebuilder.model.Image.wrap(buildAwsValue())
}
object Image {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.Image
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.Image =
      zio.aws.imagebuilder.model.Image(
        arn.map(value => value),
        `type`.map(value => value),
        name.map(value => value),
        version.map(value => value),
        platform.map(value => value),
        enhancedImageMetadataEnabled.map(value => value),
        osVersion.map(value => value),
        state.map(value => value.asEditable),
        imageRecipe.map(value => value.asEditable),
        containerRecipe.map(value => value.asEditable),
        sourcePipelineName.map(value => value),
        sourcePipelineArn.map(value => value),
        infrastructureConfiguration.map(value => value.asEditable),
        distributionConfiguration.map(value => value.asEditable),
        imageTestsConfiguration.map(value => value.asEditable),
        dateCreated.map(value => value),
        outputResources.map(value => value.asEditable),
        tags.map(value => value),
        buildType.map(value => value)
      )
    def arn: Option[ImageBuilderArn]
    def `type`: Option[zio.aws.imagebuilder.model.ImageType]
    def name: Option[ResourceName]
    def version: Option[VersionNumber]
    def platform: Option[zio.aws.imagebuilder.model.Platform]
    def enhancedImageMetadataEnabled: Option[NullableBoolean]
    def osVersion: Option[OsVersion]
    def state: Option[zio.aws.imagebuilder.model.ImageState.ReadOnly]
    def imageRecipe: Option[zio.aws.imagebuilder.model.ImageRecipe.ReadOnly]
    def containerRecipe
        : Option[zio.aws.imagebuilder.model.ContainerRecipe.ReadOnly]
    def sourcePipelineName: Option[ResourceName]
    def sourcePipelineArn: Option[Arn]
    def infrastructureConfiguration: Option[
      zio.aws.imagebuilder.model.InfrastructureConfiguration.ReadOnly
    ]
    def distributionConfiguration
        : Option[zio.aws.imagebuilder.model.DistributionConfiguration.ReadOnly]
    def imageTestsConfiguration
        : Option[zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly]
    def dateCreated: Option[DateTime]
    def outputResources
        : Option[zio.aws.imagebuilder.model.OutputResources.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def buildType: Option[zio.aws.imagebuilder.model.BuildType]
    def getArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, zio.aws.imagebuilder.model.ImageType] =
      AwsError.unwrapOptionField("type", `type`)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getPlatform: ZIO[Any, AwsError, zio.aws.imagebuilder.model.Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getEnhancedImageMetadataEnabled: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField(
        "enhancedImageMetadataEnabled",
        enhancedImageMetadataEnabled
      )
    def getOsVersion: ZIO[Any, AwsError, OsVersion] =
      AwsError.unwrapOptionField("osVersion", osVersion)
    def getState
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.ImageState.ReadOnly] =
      AwsError.unwrapOptionField("state", state)
    def getImageRecipe
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.ImageRecipe.ReadOnly] =
      AwsError.unwrapOptionField("imageRecipe", imageRecipe)
    def getContainerRecipe: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ContainerRecipe.ReadOnly
    ] = AwsError.unwrapOptionField("containerRecipe", containerRecipe)
    def getSourcePipelineName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("sourcePipelineName", sourcePipelineName)
    def getSourcePipelineArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("sourcePipelineArn", sourcePipelineArn)
    def getInfrastructureConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.InfrastructureConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "infrastructureConfiguration",
      infrastructureConfiguration
    )
    def getDistributionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.DistributionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "distributionConfiguration",
      distributionConfiguration
    )
    def getImageTestsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "imageTestsConfiguration",
      imageTestsConfiguration
    )
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getOutputResources: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.OutputResources.ReadOnly
    ] = AwsError.unwrapOptionField("outputResources", outputResources)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getBuildType: ZIO[Any, AwsError, zio.aws.imagebuilder.model.BuildType] =
      AwsError.unwrapOptionField("buildType", buildType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.Image
  ) extends zio.aws.imagebuilder.model.Image.ReadOnly {
    override val arn: Option[ImageBuilderArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val `type`: Option[zio.aws.imagebuilder.model.ImageType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.imagebuilder.model.ImageType.wrap(value))
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val version: Option[VersionNumber] = scala
      .Option(impl.version())
      .map(value => zio.aws.imagebuilder.model.primitives.VersionNumber(value))
    override val platform: Option[zio.aws.imagebuilder.model.Platform] = scala
      .Option(impl.platform())
      .map(value => zio.aws.imagebuilder.model.Platform.wrap(value))
    override val enhancedImageMetadataEnabled: Option[NullableBoolean] = scala
      .Option(impl.enhancedImageMetadataEnabled())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.NullableBoolean(value)
      )
    override val osVersion: Option[OsVersion] = scala
      .Option(impl.osVersion())
      .map(value => zio.aws.imagebuilder.model.primitives.OsVersion(value))
    override val state: Option[zio.aws.imagebuilder.model.ImageState.ReadOnly] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.imagebuilder.model.ImageState.wrap(value))
    override val imageRecipe
        : Option[zio.aws.imagebuilder.model.ImageRecipe.ReadOnly] = scala
      .Option(impl.imageRecipe())
      .map(value => zio.aws.imagebuilder.model.ImageRecipe.wrap(value))
    override val containerRecipe
        : Option[zio.aws.imagebuilder.model.ContainerRecipe.ReadOnly] = scala
      .Option(impl.containerRecipe())
      .map(value => zio.aws.imagebuilder.model.ContainerRecipe.wrap(value))
    override val sourcePipelineName: Option[ResourceName] = scala
      .Option(impl.sourcePipelineName())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val sourcePipelineArn: Option[Arn] = scala
      .Option(impl.sourcePipelineArn())
      .map(value => zio.aws.imagebuilder.model.primitives.Arn(value))
    override val infrastructureConfiguration: Option[
      zio.aws.imagebuilder.model.InfrastructureConfiguration.ReadOnly
    ] = scala
      .Option(impl.infrastructureConfiguration())
      .map(value =>
        zio.aws.imagebuilder.model.InfrastructureConfiguration.wrap(value)
      )
    override val distributionConfiguration: Option[
      zio.aws.imagebuilder.model.DistributionConfiguration.ReadOnly
    ] = scala
      .Option(impl.distributionConfiguration())
      .map(value =>
        zio.aws.imagebuilder.model.DistributionConfiguration.wrap(value)
      )
    override val imageTestsConfiguration
        : Option[zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly] =
      scala
        .Option(impl.imageTestsConfiguration())
        .map(value =>
          zio.aws.imagebuilder.model.ImageTestsConfiguration.wrap(value)
        )
    override val dateCreated: Option[DateTime] = scala
      .Option(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val outputResources
        : Option[zio.aws.imagebuilder.model.OutputResources.ReadOnly] = scala
      .Option(impl.outputResources())
      .map(value => zio.aws.imagebuilder.model.OutputResources.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val buildType: Option[zio.aws.imagebuilder.model.BuildType] = scala
      .Option(impl.buildType())
      .map(value => zio.aws.imagebuilder.model.BuildType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.Image
  ): zio.aws.imagebuilder.model.Image.ReadOnly = new Wrapper(impl)
}
