package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters._
sealed trait BuildType {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.BuildType
}
object BuildType {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.BuildType
  ): zio.aws.imagebuilder.model.BuildType = value match {
    case software.amazon.awssdk.services.imagebuilder.model.BuildType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.BuildType.USER_INITIATED =>
      val r = USER_INITIATED
      r
    case software.amazon.awssdk.services.imagebuilder.model.BuildType.SCHEDULED =>
      val r = SCHEDULED
      r
    case software.amazon.awssdk.services.imagebuilder.model.BuildType.IMPORT =>
      val r = IMPORT
      r
  }
  case object unknownToSdkVersion extends zio.aws.imagebuilder.model.BuildType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.BuildType =
      software.amazon.awssdk.services.imagebuilder.model.BuildType.UNKNOWN_TO_SDK_VERSION
  }
  case object USER_INITIATED extends zio.aws.imagebuilder.model.BuildType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.BuildType =
      software.amazon.awssdk.services.imagebuilder.model.BuildType.USER_INITIATED
  }
  case object SCHEDULED extends zio.aws.imagebuilder.model.BuildType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.BuildType =
      software.amazon.awssdk.services.imagebuilder.model.BuildType.SCHEDULED
  }
  case object IMPORT extends zio.aws.imagebuilder.model.BuildType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.BuildType =
      software.amazon.awssdk.services.imagebuilder.model.BuildType.IMPORT
  }
}
