package zio.aws.imagebuilder.model
import java.lang.Integer
import zio.aws.imagebuilder.model.primitives.{
  NullableBoolean,
  PaginationToken,
  RestrictedInteger
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListImagesRequest(
    owner: Option[zio.aws.imagebuilder.model.Ownership] = None,
    filters: Option[Iterable[zio.aws.imagebuilder.model.Filter]] = None,
    byName: Option[Boolean] = None,
    maxResults: Option[RestrictedInteger] = None,
    nextToken: Option[PaginationToken] = None,
    includeDeprecated: Option[NullableBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest = {
    import ListImagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest
      .builder()
      .optionallyWith(owner.map(value => value.unwrap))(_.owner)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(byName.map(value => value: java.lang.Boolean))(_.byName)
      .optionallyWith(
        maxResults.map(value => RestrictedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        includeDeprecated.map(value =>
          NullableBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.includeDeprecated)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ListImagesRequest.ReadOnly =
    zio.aws.imagebuilder.model.ListImagesRequest.wrap(buildAwsValue())
}
object ListImagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListImagesRequest =
      zio.aws.imagebuilder.model.ListImagesRequest(
        owner.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        byName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        includeDeprecated.map(value => value)
      )
    def owner: Option[zio.aws.imagebuilder.model.Ownership]
    def filters: Option[List[zio.aws.imagebuilder.model.Filter.ReadOnly]]
    def byName: Option[Boolean]
    def maxResults: Option[RestrictedInteger]
    def nextToken: Option[PaginationToken]
    def includeDeprecated: Option[NullableBoolean]
    def getOwner: ZIO[Any, AwsError, zio.aws.imagebuilder.model.Ownership] =
      AwsError.unwrapOptionField("owner", owner)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.imagebuilder.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getByName: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("byName", byName)
    def getMaxResults: ZIO[Any, AwsError, RestrictedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getIncludeDeprecated: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("includeDeprecated", includeDeprecated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest
  ) extends zio.aws.imagebuilder.model.ListImagesRequest.ReadOnly {
    override val owner: Option[zio.aws.imagebuilder.model.Ownership] = scala
      .Option(impl.owner())
      .map(value => zio.aws.imagebuilder.model.Ownership.wrap(value))
    override val filters
        : Option[List[zio.aws.imagebuilder.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.Filter.wrap(item)
        }.toList
      )
    override val byName: Option[Boolean] =
      scala.Option(impl.byName()).map(value => value: Boolean)
    override val maxResults: Option[RestrictedInteger] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.RestrictedInteger(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
    override val includeDeprecated: Option[NullableBoolean] = scala
      .Option(impl.includeDeprecated())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.NullableBoolean(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest
  ): zio.aws.imagebuilder.model.ListImagesRequest.ReadOnly = new Wrapper(impl)
}
