package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters._
sealed trait ImageType {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.ImageType
}
object ImageType {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.ImageType
  ): zio.aws.imagebuilder.model.ImageType = value match {
    case software.amazon.awssdk.services.imagebuilder.model.ImageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageType.AMI =>
      val r = AMI
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageType.DOCKER =>
      val r = DOCKER
      r
  }
  case object unknownToSdkVersion extends zio.aws.imagebuilder.model.ImageType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageType =
      software.amazon.awssdk.services.imagebuilder.model.ImageType.UNKNOWN_TO_SDK_VERSION
  }
  case object AMI extends zio.aws.imagebuilder.model.ImageType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageType =
      software.amazon.awssdk.services.imagebuilder.model.ImageType.AMI
  }
  case object DOCKER extends zio.aws.imagebuilder.model.ImageType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageType =
      software.amazon.awssdk.services.imagebuilder.model.ImageType.DOCKER
  }
}
