package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetImageResponse(
    requestId: Option[NonEmptyString] = None,
    image: Option[zio.aws.imagebuilder.model.Image] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetImageResponse = {
    import GetImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetImageResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(image.map(value => value.buildAwsValue()))(_.image)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.GetImageResponse.ReadOnly =
    zio.aws.imagebuilder.model.GetImageResponse.wrap(buildAwsValue())
}
object GetImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.GetImageResponse =
      zio.aws.imagebuilder.model.GetImageResponse(
        requestId.map(value => value),
        image.map(value => value.asEditable)
      )
    def requestId: Option[NonEmptyString]
    def image: Option[zio.aws.imagebuilder.model.Image.ReadOnly]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getImage
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.Image.ReadOnly] =
      AwsError.unwrapOptionField("image", image)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetImageResponse
  ) extends zio.aws.imagebuilder.model.GetImageResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val image: Option[zio.aws.imagebuilder.model.Image.ReadOnly] =
      scala
        .Option(impl.image())
        .map(value => zio.aws.imagebuilder.model.Image.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetImageResponse
  ): zio.aws.imagebuilder.model.GetImageResponse.ReadOnly = new Wrapper(impl)
}
