package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetDistributionConfigurationResponse(
    requestId: Option[NonEmptyString] = None,
    distributionConfiguration: Option[
      zio.aws.imagebuilder.model.DistributionConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationResponse = {
    import GetDistributionConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        distributionConfiguration.map(value => value.buildAwsValue())
      )(_.distributionConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.GetDistributionConfigurationResponse.ReadOnly =
    zio.aws.imagebuilder.model.GetDistributionConfigurationResponse
      .wrap(buildAwsValue())
}
object GetDistributionConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.GetDistributionConfigurationResponse =
      zio.aws.imagebuilder.model.GetDistributionConfigurationResponse(
        requestId.map(value => value),
        distributionConfiguration.map(value => value.asEditable)
      )
    def requestId: Option[NonEmptyString]
    def distributionConfiguration
        : Option[zio.aws.imagebuilder.model.DistributionConfiguration.ReadOnly]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getDistributionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.DistributionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "distributionConfiguration",
      distributionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationResponse
  ) extends zio.aws.imagebuilder.model.GetDistributionConfigurationResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val distributionConfiguration: Option[
      zio.aws.imagebuilder.model.DistributionConfiguration.ReadOnly
    ] = scala
      .Option(impl.distributionConfiguration())
      .map(value =>
        zio.aws.imagebuilder.model.DistributionConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationResponse
  ): zio.aws.imagebuilder.model.GetDistributionConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
