package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NullableBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SystemsManagerAgent(
    uninstallAfterBuild: Option[NullableBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.SystemsManagerAgent = {
    import SystemsManagerAgent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.SystemsManagerAgent
      .builder()
      .optionallyWith(
        uninstallAfterBuild.map(value =>
          NullableBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.uninstallAfterBuild)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.SystemsManagerAgent.ReadOnly =
    zio.aws.imagebuilder.model.SystemsManagerAgent.wrap(buildAwsValue())
}
object SystemsManagerAgent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.SystemsManagerAgent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.SystemsManagerAgent =
      zio.aws.imagebuilder.model
        .SystemsManagerAgent(uninstallAfterBuild.map(value => value))
    def uninstallAfterBuild: Option[NullableBoolean]
    def getUninstallAfterBuild: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("uninstallAfterBuild", uninstallAfterBuild)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.SystemsManagerAgent
  ) extends zio.aws.imagebuilder.model.SystemsManagerAgent.ReadOnly {
    override val uninstallAfterBuild: Option[NullableBoolean] = scala
      .Option(impl.uninstallAfterBuild())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.NullableBoolean(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.SystemsManagerAgent
  ): zio.aws.imagebuilder.model.SystemsManagerAgent.ReadOnly = new Wrapper(impl)
}
