package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  InstanceProfileNameType,
  ImageBuilderArn,
  TagValue,
  InstanceType,
  DateTime,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InfrastructureConfigurationSummary(
    arn: Option[ImageBuilderArn] = None,
    name: Option[ResourceName] = None,
    description: Option[NonEmptyString] = None,
    dateCreated: Option[DateTime] = None,
    dateUpdated: Option[DateTime] = None,
    resourceTags: Option[Map[TagKey, TagValue]] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    instanceTypes: Option[Iterable[InstanceType]] = None,
    instanceProfileName: Option[InstanceProfileNameType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfigurationSummary = {
    import InfrastructureConfigurationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfigurationSummary
      .builder()
      .optionallyWith(
        arn.map(value => ImageBuilderArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(
        dateUpdated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateUpdated)
      .optionallyWith(
        resourceTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.resourceTags)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        instanceTypes.map(value =>
          value.map { item =>
            InstanceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceTypes)
      .optionallyWith(
        instanceProfileName.map(value =>
          InstanceProfileNameType.unwrap(value): java.lang.String
        )
      )(_.instanceProfileName)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.InfrastructureConfigurationSummary.ReadOnly =
    zio.aws.imagebuilder.model.InfrastructureConfigurationSummary
      .wrap(buildAwsValue())
}
object InfrastructureConfigurationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfigurationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.InfrastructureConfigurationSummary =
      zio.aws.imagebuilder.model.InfrastructureConfigurationSummary(
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        dateCreated.map(value => value),
        dateUpdated.map(value => value),
        resourceTags.map(value => value),
        tags.map(value => value),
        instanceTypes.map(value => value),
        instanceProfileName.map(value => value)
      )
    def arn: Option[ImageBuilderArn]
    def name: Option[ResourceName]
    def description: Option[NonEmptyString]
    def dateCreated: Option[DateTime]
    def dateUpdated: Option[DateTime]
    def resourceTags: Option[Map[TagKey, TagValue]]
    def tags: Option[Map[TagKey, TagValue]]
    def instanceTypes: Option[List[InstanceType]]
    def instanceProfileName: Option[InstanceProfileNameType]
    def getArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getDateUpdated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateUpdated", dateUpdated)
    def getResourceTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("resourceTags", resourceTags)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getInstanceTypes: ZIO[Any, AwsError, List[InstanceType]] =
      AwsError.unwrapOptionField("instanceTypes", instanceTypes)
    def getInstanceProfileName: ZIO[Any, AwsError, InstanceProfileNameType] =
      AwsError.unwrapOptionField("instanceProfileName", instanceProfileName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfigurationSummary
  ) extends zio.aws.imagebuilder.model.InfrastructureConfigurationSummary.ReadOnly {
    override val arn: Option[ImageBuilderArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val dateCreated: Option[DateTime] = scala
      .Option(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val dateUpdated: Option[DateTime] = scala
      .Option(impl.dateUpdated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val resourceTags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.resourceTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val instanceTypes: Option[List[InstanceType]] = scala
      .Option(impl.instanceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.primitives.InstanceType(item)
        }.toList
      )
    override val instanceProfileName: Option[InstanceProfileNameType] = scala
      .Option(impl.instanceProfileName())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.InstanceProfileNameType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfigurationSummary
  ): zio.aws.imagebuilder.model.InfrastructureConfigurationSummary.ReadOnly =
    new Wrapper(impl)
}
